#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "EOS Fluid Characterization \"PR79 Library\""
show title

$Expt << END
#                               Tc           Pc                                     Tb                                     Vc                          VcVis                     Visc                    
# Component        MW          (R)         (psia)         AF          VTran         (F)          SG          Zc        (ft3/lbmol)      ZcVis       (ft3/lbmol)      Pchor       (cp)                  Full
#-----------   ---------   -----------   ----------   ----------   ----------   ----------   ---------   ---------   --------------   ---------   --------------   --------   ----------   ---------------------------
  HE              4.003        9.3420       32.924     -0.39000     -0.26365     -452.183     0.06428     0.30142        0.91786       0.30142        0.91786        19.20          NaN     "Helium"                 
  HELIUM          4.003        9.3420       32.924     -0.39000     -0.26365     -452.183     0.06428     0.30142        0.91786       0.30142        0.91786        19.20          NaN     "Helium"                 
  NE             20.180       79.9200      400.304     -0.01600     -0.32239     -410.688     0.45422     0.31177        0.66797       0.31177        0.66797        41.30          NaN     "Neon"                   
  NEON           20.180       79.9200      400.304     -0.01600     -0.32239     -410.688     0.45422     0.31177        0.66797       0.31177        0.66797        41.30          NaN     "Neon"                   
  AR             39.948      271.5480      710.395     -0.00200     -0.18769     -302.755     0.48492     0.29119        1.19450       0.29119        1.19450        74.70          NaN     "Argon"                  
  ARGON          39.948      271.5480      710.395     -0.00200     -0.18769     -302.755     0.48492     0.29119        1.19450       0.29119        1.19450        74.70          NaN     "Argon"                  
  KR             83.800      376.9200      797.708      0.00227     -0.15572     -244.138     0.82933     0.28810        1.46088       0.28810        1.46088       148.80          NaN     "Krypton"                
  KRYPTON        83.800      376.9200      797.708      0.00227     -0.15572     -244.138     0.82933     0.28810        1.46088       0.28810        1.46088       148.80          NaN     "Krypton"                
  XE            131.290      521.5320      847.020      0.00710     -0.09103     -162.652     1.19315     0.28606        1.89018       0.28606        1.89018       229.00          NaN     "Xenon"                  
  XENON         131.290      521.5320      847.020      0.00710     -0.09103     -162.652     1.19315     0.28606        1.89018       0.28606        1.89018       229.00          NaN     "Xenon"                  
  RN            222.018      678.6000      913.738     -0.02254     -0.05750      -82.030     3.66123     0.28138        2.24258       0.28138        2.24258       382.30          NaN     "Radon"                  
  RADON         222.018      678.6000      913.738     -0.02254     -0.05750      -82.030     3.66123     0.28138        2.24258       0.28138        2.24258       382.30          NaN     "Radon"                  
  H2              2.016       59.3640      187.534     -0.21700     -0.35561     -423.203     0.02840     0.30273        1.02839       0.30273        1.02839        35.00          NaN     "Hydrogen"               
  HYDROGEN        2.016       59.3640      187.534     -0.21700     -0.35561     -423.203     0.02840     0.30273        1.02839       0.30273        1.02839        35.00          NaN     "Hydrogen"               
  N2             28.014      227.1600      492.838      0.03700     -0.16758     -320.625     0.28339     0.29178        1.44326       0.29178        1.44326        59.10          NaN     "Nitrogen"               
  NITROGEN       28.014      227.1600      492.838      0.03700     -0.16758     -320.625     0.28339     0.29178        1.44326       0.29178        1.44326        59.10          NaN     "Nitrogen"               
  CO             28.010      239.1300      506.762      0.04500     -0.14588     -313.268     0.27824     0.29449        1.49132       0.29449        1.49132        61.70          NaN     "Carbon Monoxide"        
  O2             31.999      278.2440      731.425      0.02481     -0.15218     -297.364     0.39368     0.28789        1.17527       0.28789        1.17527        53.10          NaN     "Oxygen"                 
  OXYGEN         31.999      278.2440      731.425      0.02481     -0.15218     -297.364     0.39368     0.28789        1.17527       0.28789        1.17527        53.10          NaN     "Oxygen"                 
  NO             30.006      324.0000      939.845      0.58200     -0.07398     -241.585     0.41528     0.25113        0.92907       0.25113        0.92907        56.60          NaN     "Nitric Oxide"           
  N2O            44.013      557.2800     1052.249      0.16672     -0.07057     -127.264     0.75419     0.27338        1.55379       0.27338        1.55379        41.30          NaN     "Nitrous Oxide"          
  CO2            44.010      547.4160     1069.508      0.22500      0.00191     -126.879     0.76193     0.27433        1.50686       0.27433        1.50686        80.00          NaN     "Carbon Dioxide"         
  H2S            34.082      672.1200     1299.973      0.09000     -0.04470      -78.613     0.83007     0.28292        1.56981       0.28292        1.56981        80.10          NaN     "Hydrogen Sulfide"       
  NH3            17.031      729.7200     1646.613      0.25700      0.12897      -27.494     0.61280     0.24409        1.16086       0.24409        1.16086        58.00          NaN     "Ammonia"                
  AMMONIA        17.031      729.7200     1646.613      0.25700      0.12897      -27.494     0.61280     0.24409        1.16086       0.24409        1.16086        58.00          NaN     "Ammonia"                
  SO2            64.065      775.4400     1143.478      0.25723     -0.01919       13.964     1.39305     0.26853        1.95425       0.26853        1.95425       127.30          NaN     "Sulfur Dioxide"         
  NO2            46.006      775.8000     1464.881      0.83400      0.05817       70.300     1.46273     0.47294        2.68790       0.22055        1.25350        72.80      0.22212     "Nitrogen Dioxide"       
  N2O4           92.011      775.8180     1464.881      1.00700     -1.11270       84.030     1.45368     0.47067        2.67508       0.43990        2.50019       145.60      0.30053     "Nitrogen Tetroxide"     
  H2O            18.015     1164.8520     3200.113      0.34400      0.16658      214.472     1.00508     0.22943        0.89623       0.22763        0.88921        52.80      1.12658     "Water"                  
  WATER          18.015     1164.8520     3200.113      0.34400      0.16658      214.472     1.00508     0.22943        0.89623       0.22763        0.88921        52.80      1.12658     "Water"                  
  C1             16.043      343.0080      667.029      0.01100     -0.14996     -258.868     0.14609     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  CH4            16.043      343.0080      667.029      0.01100     -0.14996     -258.868     0.14609     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  METHANE        16.043      343.0080      667.029      0.01100     -0.14996     -258.868     0.14609     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  C2             30.070      549.5760      706.624      0.09900     -0.06280     -127.690     0.32976     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  C2H6           30.070      549.5760      706.624      0.09900     -0.06280     -127.690     0.32976     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  ETHANE         30.070      549.5760      706.624      0.09900     -0.06280     -127.690     0.32976     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  C3             44.097      665.6940      616.120      0.15200     -0.06381      -43.989     0.50977     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  C3H8           44.097      665.6940      616.120      0.15200     -0.06381      -43.989     0.50977     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  PROPANE        44.097      665.6940      616.120      0.15200     -0.06381      -43.989     0.50977     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  C-C3           42.081      716.8500      808.585      0.13000     -0.32275      -27.271     0.53380     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  CYCLO-C3       42.081      716.8500      808.585      0.13000     -0.32275      -27.271     0.53380     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  C-PROPANE      42.081      716.8500      808.585      0.13000     -0.32275      -27.271     0.53380     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  CYCLOPROP      42.081      716.8500      808.585      0.13000     -0.32275      -27.271     0.53380     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  I-C4           58.123      734.1300      527.937      0.18600     -0.06197       11.015     0.57043     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  ISO-C4         58.123      734.1300      527.937      0.18600     -0.06197       11.015     0.57043     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  I-BUTANE       58.123      734.1300      527.937      0.18600     -0.06197       11.015     0.57043     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  ISOBUTANE      58.123      734.1300      527.937      0.18600     -0.06197       11.015     0.57043     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  N-C4           58.123      765.2160      550.563      0.20000     -0.05393       31.071     0.59055     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  N-BUTANE       58.123      765.2160      550.563      0.20000     -0.05393       31.071     0.59055     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  BUTANE         58.123      765.2160      550.563      0.20000     -0.05393       31.071     0.59055     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  NEO-C5         72.150      780.7500      463.976      0.19700     -0.07632       49.046     0.60199     0.26895        4.85680       0.26895        4.85680       225.90          NaN     "Neopentane"             
  NEOPENTAN      72.150      780.7500      463.976      0.19700     -0.07632       49.046     0.60199     0.26895        4.85680       0.26895        4.85680       225.90          NaN     "Neopentane"             
  C-C4           56.108      828.0000      723.738      0.18500     -0.08978       55.094     0.70002     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  CYCLO-C4       56.108      828.0000      723.738      0.18500     -0.08978       55.094     0.70002     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  C-BUTANE       56.108      828.0000      723.738      0.18500     -0.08978       55.094     0.70002     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  CYCLOBUTA      56.108      828.0000      723.738      0.18500     -0.08978       55.094     0.70002     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  I-C5           72.150      828.7020      490.373      0.22900     -0.05646       82.423     0.62952     0.27231        4.93849       0.27708        5.02513       227.40      0.23498     "Isopentane"             
  ISO-C5         72.150      828.7020      490.373      0.22900     -0.05646       82.423     0.62952     0.27231        4.93849       0.27708        5.02513       227.40      0.23498     "Isopentane"             
  I-PENTANE      72.150      828.7020      490.373      0.22900     -0.05646       82.423     0.62952     0.27231        4.93849       0.27708        5.02513       227.40      0.23498     "Isopentane"             
  ISOPENTAN      72.150      828.7020      490.373      0.22900     -0.05646       82.423     0.62952     0.27231        4.93849       0.27708        5.02513       227.40      0.23498     "Isopentane"             
  N-C5           72.150      845.4600      488.777      0.25200     -0.02928       97.136     0.63585     0.26837        4.98174       0.26834        4.98112       231.00      0.23558     "Pentane"                
  N-PENTANE      72.150      845.4600      488.777      0.25200     -0.02928       97.136     0.63585     0.26837        4.98174       0.26834        4.98112       231.00      0.23558     "Pentane"                
  PENTANE        72.150      845.4600      488.777      0.25200     -0.02928       97.136     0.63585     0.26837        4.98174       0.26834        4.98112       231.00      0.23558     "Pentane"                
  C-C5           70.134      920.8800      653.830      0.19669     -0.07568      120.614     0.74932     0.27554        4.16480       0.28986        4.38110       203.00      0.46154     "Cyclopentane"           
  CYCLO-C5       70.134      920.8800      653.830      0.19669     -0.07568      120.614     0.74932     0.27554        4.16480       0.28986        4.38110       203.00      0.46154     "Cyclopentane"           
  C-PENTANE      70.134      920.8800      653.830      0.19669     -0.07568      120.614     0.74932     0.27554        4.16480       0.28986        4.38110       203.00      0.46154     "Cyclopentane"           
  CYCLOPENT      70.134      920.8800      653.830      0.19669     -0.07568      120.614     0.74932     0.27554        4.16480       0.28986        4.38110       203.00      0.46154     "Cyclopentane"           
  22DM-C4        86.177      879.6600      446.716      0.23300     -0.07263      121.637     0.65312     0.27220        5.75223       0.27760        5.86625       263.00      0.26394     "2,2-Dimethylbutane"     
  22DM-BUTA      86.177      879.6600      446.716      0.23300     -0.07263      121.637     0.65312     0.27220        5.75223       0.27760        5.86625       263.00      0.26394     "2,2-Dimethylbutane"     
  23DM-C4        86.177      899.8200      453.968      0.24800     -0.05339      136.489     0.66541     0.26929        5.72820       0.27419        5.83236       263.40      0.29290     "2,3-Dimethylbutane"     
  23DM-BUTA      86.177      899.8200      453.968      0.24800     -0.05339      136.489     0.66541     0.26929        5.72820       0.27419        5.83236       263.40      0.29290     "2,3-Dimethylbutane"     
  2M-C5          86.177      895.5000      436.564      0.27800     -0.02956      140.585     0.65696     0.26684        5.87397       0.26916        5.92513       268.80      0.29235     "2-Methylpentane"        
  2M-PENTAN      86.177      895.5000      436.564      0.27800     -0.02956      140.585     0.65696     0.26684        5.87397       0.26916        5.92513       268.80      0.29235     "2-Methylpentane"        
  3M-C5          86.177      907.9200      452.518      0.27300     -0.04127      146.058     0.66801     0.27281        5.87397       0.27183        5.85300       267.40      0.30930     "3-Methylpentane"        
  3M-PENTAN      86.177      907.9200      452.518      0.27300     -0.04127      146.058     0.66801     0.27281        5.87397       0.27183        5.85300       267.40      0.30930     "3-Methylpentane"        
  N-C6           86.177      913.6800      438.739      0.30000     -0.01176      155.884     0.66304     0.26377        5.89479       0.26594        5.94347       271.00      0.32245     "Hexane"                 
  N-HEXANE       86.177      913.6800      438.739      0.30000     -0.01176      155.884     0.66304     0.26377        5.89479       0.26594        5.94347       271.00      0.32245     "Hexane"                 
  HEXANE         86.177      913.6800      438.739      0.30000     -0.01176      155.884     0.66304     0.26377        5.89479       0.26594        5.94347       271.00      0.32245     "Hexane"                 
  MC-C5          84.161      959.0220      548.823      0.22700     -0.05007      160.571     0.75215     0.27249        5.10989       0.28473        5.33948       243.00      0.53135     "Methylcyclopentane"     
  MC-PENTAN      84.161      959.0220      548.823      0.22700     -0.05007      160.571     0.75215     0.27249        5.10989       0.28473        5.33948       243.00      0.53135     "Methylcyclopentane"     
  22DM-C5       100.204      936.7200      401.755      0.28700     -0.03965      174.633     0.67721     0.26619        6.66048       0.27298        6.83025       305.90      0.35278     "2,2-Dimethylpentane"    
  22DM-PENT     100.204      936.7200      401.755      0.28700     -0.03965      174.633     0.67721     0.26619        6.66048       0.27298        6.83025       305.90      0.35278     "2,2-Dimethylpentane"    
  BENZENE        78.114     1011.6900      709.960      0.21000     -0.02879      175.600     0.88238     0.26815        4.10073       0.28034        4.28713       205.10      0.69219     "Benzene"                
  24DM-C5       100.204      935.4600      397.403      0.30400     -0.03227      177.069     0.67596     0.26474        6.68771       0.27137        6.85522       306.60      0.35566     "2,4-Dimethylpentane"    
  24DM-PENT     100.204      935.4600      397.403      0.30400     -0.03227      177.069     0.67596     0.26474        6.68771       0.27137        6.85522       306.60      0.35566     "2,4-Dimethylpentane"    
  C-C6           84.161      996.3000      590.739      0.21100     -0.05688      177.102     0.78173     0.27259        4.93369       0.30244        5.47386       240.80      1.05399     "Cyclohexane"            
  CYCLO-C6       84.161      996.3000      590.739      0.21100     -0.05688      177.102     0.78173     0.27259        4.93369       0.30244        5.47386       240.80      1.05399     "Cyclohexane"            
  C-HEXANE       84.161      996.3000      590.739      0.21100     -0.05688      177.102     0.78173     0.27259        4.93369       0.30244        5.47386       240.80      1.05399     "Cyclohexane"            
  CYCLOHEXA      84.161      996.3000      590.739      0.21100     -0.05688      177.102     0.78173     0.27259        4.93369       0.30244        5.47386       240.80      1.05399     "Cyclohexane"            
  223TM-C4      100.204      955.9800      427.861      0.25000     -0.06542      177.672     0.69312     0.26562        6.36894       0.27908        6.69174       299.00      0.37505     "2,2,3-Trimethylbutane"  
  223TM-BUT     100.204      955.9800      427.861      0.25000     -0.06542      177.672     0.69312     0.26562        6.36894       0.27908        6.69174       299.00      0.37505     "2,2,3-Trimethylbutane"  
  33DM-C5       100.204      965.3400      427.861      0.26900     -0.05362      187.140     0.69652     0.27396        6.63325       0.27697        6.70607       303.00      0.39761     "3,3-Dimethylpentane"    
  33DM-PENT     100.204      965.3400      427.861      0.26900     -0.05362      187.140     0.69652     0.27396        6.63325       0.27697        6.70607       303.00      0.39761     "3,3-Dimethylpentane"    
  23DM-C5       100.204      967.1400      422.060      0.29700     -0.03652      193.792     0.69816     0.25600        6.29526       0.27360        6.72825       303.40      0.41384     "2,3-Dimethylpentane"    
  23DM-PENT     100.204      967.1400      422.060      0.29700     -0.03652      193.792     0.69816     0.25600        6.29526       0.27360        6.72825       303.40      0.41384     "2,3-Dimethylpentane"    
  2M-C6         100.204      954.1800      395.953      0.33100     -0.00490      194.166     0.68180     0.26077        6.74377       0.26630        6.88687       308.80      0.39610     "2-Methylhexane"         
  2M-HEXANE     100.204      954.1800      395.953      0.33100     -0.00490      194.166     0.68180     0.26077        6.74377       0.26630        6.88687       308.80      0.39610     "2-Methylhexane"         
  3M-C6         100.204      963.3600      407.556      0.32300     -0.01535      197.464     0.69023     0.25512        6.47146       0.26894        6.82207       307.40      0.41332     "3-Methylhexane"         
  3M-HEXANE     100.204      963.3600      407.556      0.32300     -0.01535      197.464     0.69023     0.25512        6.47146       0.26894        6.82207       307.40      0.41332     "3-Methylhexane"         
  3E-C5         100.204      972.9000      419.159      0.31100     -0.01984      200.354     0.70125     0.26739        6.66048       0.27042        6.73596       305.00      0.43230     "3-Ethylpentane"         
  3E-PENTAN     100.204      972.9000      419.159      0.31100     -0.01984      200.354     0.70125     0.26739        6.66048       0.27042        6.73596       305.00      0.43230     "3-Ethylpentane"         
  N-C7          100.204      972.3600      397.403      0.35000      0.01233      209.267     0.68672     0.26110        6.85590       0.26320        6.91102       311.00      0.43539     "Heptane"                
  N-HEPTANE     100.204      972.3600      397.403      0.35000      0.01233      209.267     0.68672     0.26110        6.85590       0.26320        6.91102       311.00      0.43539     "Heptane"                
  HEPTANE       100.204      972.3600      397.403      0.35000      0.01233      209.267     0.68672     0.26110        6.85590       0.26320        6.91102       311.00      0.43539     "Heptane"                
  MC-C6          98.188     1029.9420      503.426      0.23500     -0.03843      213.515     0.77222     0.26849        5.89479       0.28729        6.30746       280.80      0.78245     "Methylcyclohexane"      
  MC-HEXANE      98.188     1029.9420      503.426      0.23500     -0.03843      213.515     0.77222     0.26849        5.89479       0.28729        6.30746       280.80      0.78245     "Methylcyclohexane"      
  EC-C5          98.188     1025.1000      492.693      0.27000     -0.02627      218.230     0.76936     0.26903        6.00692       0.27317        6.09939       283.00      0.53539     "Ethylcyclopentane"      
  EC-PENTAN      98.188     1025.1000      492.693      0.27000     -0.02627      218.230     0.76936     0.26903        6.00692       0.27317        6.09939       283.00      0.53539     "Ethylcyclopentane"      
  TOLUENE        92.141     1065.1500      595.815      0.26400      0.00394      231.222     0.86987     0.26384        5.06183       0.26667        5.11615       245.10      0.64614     "Toluene"                
  C-C7           98.188     1087.7400      556.945      0.24200     -0.04795      245.908     0.81331     0.27437        5.75063       0.27896        5.84690       280.00      0.65213     "Cycloheptane"           
  CYCLO-C7       98.188     1087.7400      556.945      0.24200     -0.04795      245.908     0.81331     0.27437        5.75063       0.27896        5.84690       280.00      0.65213     "Cycloheptane"           
  C-HEPTANE      98.188     1087.7400      556.945      0.24200     -0.04795      245.908     0.81331     0.27437        5.75063       0.27896        5.84690       280.00      0.65213     "Cycloheptane"           
  CYCLOHEPT      98.188     1087.7400      556.945      0.24200     -0.04795      245.908     0.81331     0.27437        5.75063       0.27896        5.84690       280.00      0.65213     "Cycloheptane"           
  N-C8          114.231     1023.6600      361.144      0.39900      0.03916      258.150     0.70513     0.25909        7.88108       0.26013        7.91281       351.00      0.57892     "Octane"                 
  N-OCTANE      114.231     1023.6600      361.144      0.39900      0.03916      258.150     0.70513     0.25909        7.88108       0.26013        7.91281       351.00      0.57892     "Octane"                 
  OCTANE        114.231     1023.6600      361.144      0.39900      0.03916      258.150     0.70513     0.25909        7.88108       0.26013        7.91281       351.00      0.57892     "Octane"                 
  E-BENZENE     106.167     1110.8700      523.441      0.30400      0.02183      277.351     0.86960     0.26305        5.99091       0.26254        5.97927       285.10      0.72363     "Ethylbenzene"           
  P-XYLENE      106.167     1109.1600      509.227      0.32200      0.04121      281.404     0.86371     0.25904        6.05498       0.25525        5.96647       285.10      0.65065     "p-Xylene"               
  M-XYLENE      106.167     1110.6000      513.579      0.32700      0.03650      282.706     0.86686     0.25884        6.00692       0.25621        5.94581       285.10      0.65532     "m-Xylene"               
  O-XYLENE      106.167     1134.5400      541.281      0.31200      0.01858      292.292     0.88238     0.26349        5.92683       0.26623        5.98852       285.10      0.86923     "o-Xylene"               
  N-C9          128.258     1070.2800      332.136      0.44500      0.05908      303.239     0.71982     0.25708        8.89025       0.25830        8.93253       391.00      0.75172     "Nonane"                 
  N-NONANE      128.258     1070.2800      332.136      0.44500      0.05908      303.239     0.71982     0.25708        8.89025       0.25830        8.93253       391.00      0.75172     "Nonane"                 
  NONANE        128.258     1070.2800      332.136      0.44500      0.05908      303.239     0.71982     0.25708        8.89025       0.25830        8.93253       391.00      0.75172     "Nonane"                 
  C-C8          112.215     1164.9600      517.785      0.25400     -0.02118      303.794     0.83814     0.27201        6.56757       0.27773        6.70579       320.00      0.92258     "Cyclooctane"            
  CYCLO-C8      112.215     1164.9600      517.785      0.25400     -0.02118      303.794     0.83814     0.27201        6.56757       0.27773        6.70579       320.00      0.92258     "Cyclooctane"            
  C-OCTANE      112.215     1164.9600      517.785      0.25400     -0.02118      303.794     0.83814     0.27201        6.56757       0.27773        6.70579       320.00      0.92258     "Cyclooctane"            
  CYCLOOCTA     112.215     1164.9600      517.785      0.25400     -0.02118      303.794     0.83814     0.27201        6.56757       0.27773        6.70579       320.00      0.92258     "Cyclooctane"            
  CUMENE        120.194     1135.8000      465.426      0.32600      0.02462      306.195     0.86411     0.26589        6.96323       0.26435        6.92291       322.90      0.83587     "Cumene"                 
  I-C3-BENZ     120.194     1135.8000      465.426      0.32600      0.02462      306.195     0.86411     0.26589        6.96323       0.26435        6.92291       322.90      0.83587     "Cumene"                 
  1ME-BENZE     120.194     1135.8000      465.426      0.32600      0.02462      306.195     0.86411     0.26589        6.96323       0.26435        6.92291       322.90      0.83587     "Cumene"                 
  P-BENZENE     120.194     1149.0300      464.121      0.34500      0.03545      318.804     0.86377     0.26528        7.04812       0.26584        7.06298       325.10      1.02704     "Propylbenzene"          
  1E4M-BENZ     120.194     1152.3600      468.472      0.36400      0.02687      323.813     0.86442     0.26700        7.04812       0.26791        7.07222       325.10      1.05666     "1-Ethyl-4-methylbenzene"
  135TM-BEN     120.194     1147.1400      453.533      0.39900      0.03235      328.539     0.84675     0.25376        6.88794       0.26674        7.24046       325.10      1.06804     "1,3,5-Trimethylbenzene" 
  124TM-BEN     120.194     1168.3800      468.762      0.37700      0.05504      336.977     0.87913     0.26050        6.96803       0.26206        7.00966       325.10      1.15251     "1,2,4-Trimethylbenzene" 
  N-C10         142.285     1111.8600      306.030      0.49000      0.08100      344.999     0.73183     0.25636        9.99552       0.25577        9.97248       431.00      0.95637     "Decane"                 
  N-DECANE      142.285     1111.8600      306.030      0.49000      0.08100      344.999     0.73183     0.25636        9.99552       0.25577        9.97248       431.00      0.95637     "Decane"                 
  DECANE        142.285     1111.8600      306.030      0.49000      0.08100      344.999     0.73183     0.25636        9.99552       0.25577        9.97248       431.00      0.95637     "Decane"                 
  123TM-BEN     120.194     1196.1000      500.960      0.36700      0.02813      349.261     0.89786     0.27195        6.96803       0.26888        6.88956       325.10      1.25226     "1,2,3-Trimethylbenzene" 
  N-C11         156.312     1150.2000      287.175      0.53700      0.08770      384.513     0.74179     0.25677       11.03672       0.25644       11.02225       471.00      1.19629     "Undecane"               
  N-UNDECAN     156.312     1150.2000      287.175      0.53700      0.08770      384.513     0.74179     0.25677       11.03672       0.25644       11.02225       471.00      1.19629     "Undecane"               
  UNDECANE      156.312     1150.2000      287.175      0.53700      0.08770      384.513     0.74179     0.25677       11.03672       0.25644       11.02225       471.00      1.19629     "Undecane"               
  N-C12         170.338     1184.4000      263.969      0.57600      0.11842      421.306     0.75028     0.25083       12.07792       0.25135       12.10293       511.00      1.47520     "Dodecane"               
  N-DODECAN     170.338     1184.4000      263.969      0.57600      0.11842      421.306     0.75028     0.25083       12.07792       0.25135       12.10293       511.00      1.47520     "Dodecane"               
  DODECANE      170.338     1184.4000      263.969      0.57600      0.11842      421.306     0.75028     0.25083       12.07792       0.25135       12.10293       511.00      1.47520     "Dodecane"               
  NAPHTHALE     128.174     1347.1200      587.403      0.30400      0.03554      424.785     1.01736     0.26490        6.51951       0.27752        6.83010       311.10      2.63165     "Naphthalene"            
  N-C13         184.365     1215.0000      243.663      0.61800      0.14614      455.833     0.75764     0.24636       13.18320       0.24664       13.19804       551.00      1.79642     "Tridecane"              
  N-TRIDECA     184.365     1215.0000      243.663      0.61800      0.14614      455.833     0.75764     0.24636       13.18320       0.24664       13.19804       551.00      1.79642     "Tridecane"              
  TRIDECANE     184.365     1215.0000      243.663      0.61800      0.14614      455.833     0.75764     0.24636       13.18320       0.24664       13.19804       551.00      1.79642     "Tridecane"              
  2M-NAPHTH     142.200     1369.8000      513.434      0.37400      0.05748      466.201     0.99853     0.25848        7.40053       0.27072        7.75086       351.10      2.65690     "2-Methylnaphthalene"    
  1M-NAPHTH     142.200     1389.6000      522.136      0.34800      0.08002      472.537     1.02350     0.25912        7.40053       0.26566        7.58751       351.10      2.79963     "1-Methylnaphthalene"    
  N-C14         198.392     1247.4000      227.709      0.64400      0.16753      489.011     0.76397     0.24360       14.32051       0.24332       14.30407       591.00      2.16472     "Tetradecane"            
  N-TETRADE     198.392     1247.4000      227.709      0.64400      0.16753      489.011     0.76397     0.24360       14.32051       0.24332       14.30407       591.00      2.16472     "Tetradecane"            
  TETRADECA     198.392     1247.4000      227.709      0.64400      0.16753      489.011     0.76397     0.24360       14.32051       0.24332       14.30407       591.00      2.16472     "Tetradecane"            
  DPH-C1        168.238     1368.0000      393.052      0.48100      0.15575      507.540     1.00924     0.24145        9.01839       0.25002        9.33839       419.20      3.53425     "Diphenylmethane"        
  DPH-METHA     168.238     1368.0000      393.052      0.48100      0.15575      507.540     1.00924     0.24145        9.01839       0.25002        9.33839       419.20      3.53425     "Diphenylmethane"        
  N-C15         212.419     1274.4000      214.656      0.68500      0.17978      519.523     0.76949     0.24287       15.47384       0.24201       15.41886       631.00      2.58068     "Pentadecane"            
  N-PENTADE     212.419     1274.4000      214.656      0.68500      0.17978      519.523     0.76949     0.24287       15.47384       0.24201       15.41886       631.00      2.58068     "Pentadecane"            
  PENTADECA     212.419     1274.4000      214.656      0.68500      0.17978      519.523     0.76949     0.24287       15.47384       0.24201       15.41886       631.00      2.58068     "Pentadecane"            
  N-C16         226.446     1301.4000      203.053      0.71800      0.19217      548.926     0.77438     0.24081       16.56309       0.24056       16.54557       671.00      3.04856     "Hexadecane"             
  N-HEXADEC     226.446     1301.4000      203.053      0.71800      0.19217      548.926     0.77438     0.24081       16.56309       0.24056       16.54557       671.00      3.04856     "Hexadecane"             
  HEXADECAN     226.446     1301.4000      203.053      0.71800      0.19217      548.926     0.77438     0.24081       16.56309       0.24056       16.54557       671.00      3.04856     "Hexadecane"             
  N-C17         240.473     1324.8000      194.351      0.75300      0.19477      574.925     0.77887     0.24153       17.66837       0.24147       17.66401       711.00      3.54721     "Heptadecane"            
  N-HEPTADE     240.473     1324.8000      194.351      0.75300      0.19477      574.925     0.77887     0.24153       17.66837       0.24147       17.66401       711.00      3.54721     "Heptadecane"            
  HEPTADECA     240.473     1324.8000      194.351      0.75300      0.19477      574.925     0.77887     0.24153       17.66837       0.24147       17.66401       711.00      3.54721     "Heptadecane"            
  N-C18         254.500     1344.6000      187.099      0.80000      0.19254      599.021     0.78319     0.24695       19.04595       0.24353       18.78180       751.00      4.09789     "Octadecane"             
  N-OCTADEC     254.500     1344.6000      187.099      0.80000      0.19254      599.021     0.78319     0.24695       19.04595       0.24353       18.78180       751.00      4.09789     "Octadecane"             
  OCTADECAN     254.500     1344.6000      187.099      0.80000      0.19254      599.021     0.78319     0.24695       19.04595       0.24353       18.78180       751.00      4.09789     "Octadecane"             
  N-C19         268.527     1359.0000      168.244      0.84500      0.24620      624.428     0.78648     0.21374       18.52768       0.23070       19.99783       791.00      4.73667     "Nonadecane"             
  N-NONADEC     268.527     1359.0000      168.244      0.84500      0.24620      624.428     0.78648     0.21374       18.52768       0.23070       19.99783       791.00      4.73667     "Nonadecane"             
  NONADECAN     268.527     1359.0000      168.244      0.84500      0.24620      624.428     0.78648     0.21374       18.52768       0.23070       19.99783       791.00      4.73667     "Nonadecane"             
  12DPH-BEN     230.309     1542.6000      433.663      0.51579     -0.30612      629.600     0.91020     0.23288        8.89001       0.38311       14.62482       553.30      6.67159     "1,2-Diphenylbenzene"    
  PHENANTHR     178.233     1564.2000      416.258      0.47900      0.12838      640.437     0.97699     0.22006        8.87423       0.26603       10.72814       417.10      7.30912     "Phenanthrene"           
  ANTHRACEN     178.233     1564.7400      416.258      0.50100      0.35356      645.987     1.29007     0.21998        8.87423       0.20016        8.07450       417.10      6.68134     "Anthracene"             
  N-C20         282.554     1382.4000      155.190      0.86500      0.28091      652.343     0.78647     0.20915       19.99370       0.22267       21.28563       831.00      5.43030     "Eicosane"               
  N-EICOSAN     282.554     1382.4000      155.190      0.86500      0.28091      652.343     0.78647     0.20915       19.99370       0.22267       21.28563       831.00      5.43030     "Eicosane"               
  EICOSANE      282.554     1382.4000      155.190      0.86500      0.28091      652.343     0.78647     0.20915       19.99370       0.22267       21.28563       831.00      5.43030     "Eicosane"               
  N-C21         296.580     1400.4000      149.389      0.89895      0.28147      673.700     0.78752     0.20523       20.64563       0.22372       22.50586       871.00      6.15049     "Heneicosane"            
  N-HENEICO     296.580     1400.4000      149.389      0.89895      0.28147      673.700     0.78752     0.20523       20.64563       0.22372       22.50586       871.00      6.15049     "Heneicosane"            
  HENEICOSA     296.580     1400.4000      149.389      0.89895      0.28147      673.700     0.78752     0.20523       20.64563       0.22372       22.50586       871.00      6.15049     "Heneicosane"            
  13DPH-BEN     230.309     1589.4000      359.694      0.54069      0.04334      685.400     0.98848     0.24457       11.59737       0.29493       13.98551       553.30     10.18562     "1,3-Diphenylbenzene"    
  N-C22         310.607     1414.8000      142.137      0.95693      0.29056      695.480     0.78896     0.20155       21.52916       0.22219       23.73433       911.00      6.93370     "Docosane"               
  N-DOCOSAN     310.607     1414.8000      142.137      0.95693      0.29056      695.480     0.78896     0.20155       21.52916       0.22219       23.73433       911.00      6.93370     "Docosane"               
  DOCOSANE      310.607     1414.8000      142.137      0.95693      0.29056      695.480     0.78896     0.20155       21.52916       0.22219       23.73433       911.00      6.93370     "Docosane"               
  14DPH-BEN     230.309     1634.4000      433.663      0.58576     -0.09594      708.800     1.02275     0.28872       11.67746       0.33530       13.56146       553.30     12.06661     "1,4-Diphenylbenzene"    
  N-C23         324.634     1422.0000      133.435      1.06175      0.31066      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  N-TRICOSA     324.634     1422.0000      133.435      1.06175      0.31066      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  TRICOSANE     324.634     1422.0000      133.435      1.06175      0.31066      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  N-C24         338.661     1440.0000      126.183      1.06221      0.32510      736.340     0.79111     0.19430       23.79614       0.21438       26.25435       991.00      8.66387     "Tetracosane"            
  N-TETRACO     338.661     1440.0000      126.183      1.06221      0.32510      736.340     0.79111     0.19430       23.79614       0.21438       26.25435       991.00      8.66387     "Tetracosane"            
  TETRACOSA     338.661     1440.0000      126.183      1.06221      0.32510      736.340     0.79111     0.19430       23.79614       0.21438       26.25435       991.00      8.66387     "Tetracosane"            
END
set xlabel "Molecular Weight"
set ylabel "Critical Temperature (R)"
set output "Figures/Table_001_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:3 with points notitle
set ylabel "Critical Pressure (psia)"
set output "Figures/Table_001_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:4 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_001_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:5 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_001_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:6 with points notitle
set ylabel "Boiling Temperature (F)"
set output "Figures/Table_001_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:7 with points notitle
set ylabel "Specific Gravity"
set output "Figures/Table_001_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:8 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_001_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:9 with points notitle
set ylabel "Critical Volume (ft3/lbmol)"
set output "Figures/Table_001_VC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:10 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_001_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:11 with points notitle
set ylabel "Viscosity Vc (ft3/lbmol)"
set output "Figures/Table_001_VISV_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:12 with points notitle
set ylabel "Parachor"
set output "Figures/Table_001_PCHOR_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:13 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_001_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:14 with points notitle

set title "EOS Fluid Characterization \"PR77 Library\""
show title

$Expt << END
#                               Tc           Pc                                     Tb                                     Vc                          VcVis                     Visc                    
# Component        MW          (R)         (psia)         AF          VTran         (F)          SG          Zc        (ft3/lbmol)      ZcVis       (ft3/lbmol)      Pchor       (cp)                  Full
#-----------   ---------   -----------   ----------   ----------   ----------   ----------   ---------   ---------   --------------   ---------   --------------   --------   ----------   ---------------------------
  HE              4.003        9.3420       32.924     -0.39000     -0.26365     -452.183     0.06428     0.30142        0.91786       0.30142        0.91786        19.20          NaN     "Helium"                 
  HELIUM          4.003        9.3420       32.924     -0.39000     -0.26365     -452.183     0.06428     0.30142        0.91786       0.30142        0.91786        19.20          NaN     "Helium"                 
  NE             20.180       79.9200      400.304     -0.01600     -0.32239     -410.688     0.45422     0.31177        0.66797       0.31177        0.66797        41.30          NaN     "Neon"                   
  NEON           20.180       79.9200      400.304     -0.01600     -0.32239     -410.688     0.45422     0.31177        0.66797       0.31177        0.66797        41.30          NaN     "Neon"                   
  AR             39.948      271.5480      710.395     -0.00200     -0.18769     -302.755     0.48492     0.29119        1.19450       0.29119        1.19450        74.70          NaN     "Argon"                  
  ARGON          39.948      271.5480      710.395     -0.00200     -0.18769     -302.755     0.48492     0.29119        1.19450       0.29119        1.19450        74.70          NaN     "Argon"                  
  KR             83.800      376.9200      797.708      0.00227     -0.15572     -244.138     0.82933     0.28810        1.46088       0.28810        1.46088       148.80          NaN     "Krypton"                
  KRYPTON        83.800      376.9200      797.708      0.00227     -0.15572     -244.138     0.82933     0.28810        1.46088       0.28810        1.46088       148.80          NaN     "Krypton"                
  XE            131.290      521.5320      847.020      0.00710     -0.09103     -162.652     1.19315     0.28606        1.89018       0.28606        1.89018       229.00          NaN     "Xenon"                  
  XENON         131.290      521.5320      847.020      0.00710     -0.09103     -162.652     1.19315     0.28606        1.89018       0.28606        1.89018       229.00          NaN     "Xenon"                  
  RN            222.018      678.6000      913.738     -0.02254     -0.05750      -82.030     3.66123     0.28138        2.24258       0.28138        2.24258       382.30          NaN     "Radon"                  
  RADON         222.018      678.6000      913.738     -0.02254     -0.05750      -82.030     3.66123     0.28138        2.24258       0.28138        2.24258       382.30          NaN     "Radon"                  
  H2              2.016       59.3640      187.534     -0.21700     -0.35561     -423.203     0.02840     0.30273        1.02839       0.30273        1.02839        35.00          NaN     "Hydrogen"               
  HYDROGEN        2.016       59.3640      187.534     -0.21700     -0.35561     -423.203     0.02840     0.30273        1.02839       0.30273        1.02839        35.00          NaN     "Hydrogen"               
  N2             28.014      227.1600      492.838      0.03700     -0.16758     -320.625     0.28339     0.29178        1.44326       0.29178        1.44326        59.10          NaN     "Nitrogen"               
  NITROGEN       28.014      227.1600      492.838      0.03700     -0.16758     -320.625     0.28339     0.29178        1.44326       0.29178        1.44326        59.10          NaN     "Nitrogen"               
  CO             28.010      239.1300      506.762      0.04500     -0.14588     -313.268     0.27824     0.29449        1.49132       0.29449        1.49132        61.70          NaN     "Carbon Monoxide"        
  O2             31.999      278.2440      731.425      0.02481     -0.15218     -297.364     0.39368     0.28789        1.17527       0.28789        1.17527        53.10          NaN     "Oxygen"                 
  OXYGEN         31.999      278.2440      731.425      0.02481     -0.15218     -297.364     0.39368     0.28789        1.17527       0.28789        1.17527        53.10          NaN     "Oxygen"                 
  NO             30.006      324.0000      939.845      0.58200     -0.07286     -241.940     0.41539     0.25113        0.92907       0.25113        0.92907        56.60          NaN     "Nitric Oxide"           
  N2O            44.013      557.2800     1052.249      0.16672     -0.07057     -127.264     0.75419     0.27338        1.55379       0.27338        1.55379        41.30          NaN     "Nitrous Oxide"          
  CO2            44.010      547.4160     1069.508      0.22500      0.00191     -126.879     0.76193     0.27433        1.50686       0.27433        1.50686        80.00          NaN     "Carbon Dioxide"         
  H2S            34.082      672.1200     1299.973      0.09000     -0.04470      -78.613     0.83007     0.28292        1.56981       0.28292        1.56981        80.10          NaN     "Hydrogen Sulfide"       
  NH3            17.031      729.7200     1646.613      0.25700      0.12897      -27.494     0.61280     0.24409        1.16086       0.24409        1.16086        58.00          NaN     "Ammonia"                
  AMMONIA        17.031      729.7200     1646.613      0.25700      0.12897      -27.494     0.61280     0.24409        1.16086       0.24409        1.16086        58.00          NaN     "Ammonia"                
  SO2            64.065      775.4400     1143.478      0.25723     -0.01919       13.964     1.39305     0.26853        1.95425       0.26853        1.95425       127.30          NaN     "Sulfur Dioxide"         
  NO2            46.006      775.8000     1464.881      0.83400      0.06161       67.506     1.46286     0.47294        2.68790       0.22053        1.25338        72.80      0.22211     "Nitrogen Dioxide"       
  N2O4           92.011      775.8180     1464.881      1.00700     -1.10735       79.583     1.45379     0.47067        2.67508       0.43987        2.50000       145.60      0.30053     "Nitrogen Tetroxide"     
  H2O            18.015     1164.8520     3200.113      0.34400      0.16658      214.472     1.00508     0.22943        0.89623       0.22763        0.88921        52.80      1.12658     "Water"                  
  WATER          18.015     1164.8520     3200.113      0.34400      0.16658      214.472     1.00508     0.22943        0.89623       0.22763        0.88921        52.80      1.12658     "Water"                  
  C1             16.043      343.0080      667.029      0.01100     -0.14996     -258.868     0.14609     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  CH4            16.043      343.0080      667.029      0.01100     -0.14996     -258.868     0.14609     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  METHANE        16.043      343.0080      667.029      0.01100     -0.14996     -258.868     0.14609     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  C2             30.070      549.5760      706.624      0.09900     -0.06280     -127.690     0.32976     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  C2H6           30.070      549.5760      706.624      0.09900     -0.06280     -127.690     0.32976     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  ETHANE         30.070      549.5760      706.624      0.09900     -0.06280     -127.690     0.32976     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  C3             44.097      665.6940      616.120      0.15200     -0.06381      -43.989     0.50977     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  C3H8           44.097      665.6940      616.120      0.15200     -0.06381      -43.989     0.50977     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  PROPANE        44.097      665.6940      616.120      0.15200     -0.06381      -43.989     0.50977     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  C-C3           42.081      716.8500      808.585      0.13000     -0.32275      -27.271     0.53380     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  CYCLO-C3       42.081      716.8500      808.585      0.13000     -0.32275      -27.271     0.53380     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  C-PROPANE      42.081      716.8500      808.585      0.13000     -0.32275      -27.271     0.53380     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  CYCLOPROP      42.081      716.8500      808.585      0.13000     -0.32275      -27.271     0.53380     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  I-C4           58.123      734.1300      527.937      0.18600     -0.06197       11.015     0.57043     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  ISO-C4         58.123      734.1300      527.937      0.18600     -0.06197       11.015     0.57043     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  I-BUTANE       58.123      734.1300      527.937      0.18600     -0.06197       11.015     0.57043     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  ISOBUTANE      58.123      734.1300      527.937      0.18600     -0.06197       11.015     0.57043     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  N-C4           58.123      765.2160      550.563      0.20000     -0.05393       31.071     0.59055     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  N-BUTANE       58.123      765.2160      550.563      0.20000     -0.05393       31.071     0.59055     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  BUTANE         58.123      765.2160      550.563      0.20000     -0.05393       31.071     0.59055     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  NEO-C5         72.150      780.7500      463.976      0.19700     -0.07632       49.046     0.60199     0.26895        4.85680       0.26895        4.85680       225.90          NaN     "Neopentane"             
  NEOPENTAN      72.150      780.7500      463.976      0.19700     -0.07632       49.046     0.60199     0.26895        4.85680       0.26895        4.85680       225.90          NaN     "Neopentane"             
  C-C4           56.108      828.0000      723.738      0.18500     -0.08978       55.094     0.70002     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  CYCLO-C4       56.108      828.0000      723.738      0.18500     -0.08978       55.094     0.70002     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  C-BUTANE       56.108      828.0000      723.738      0.18500     -0.08978       55.094     0.70002     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  CYCLOBUTA      56.108      828.0000      723.738      0.18500     -0.08978       55.094     0.70002     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  I-C5           72.150      828.7020      490.373      0.22900     -0.05646       82.423     0.62952     0.27231        4.93849       0.27708        5.02513       227.40      0.23498     "Isopentane"             
  ISO-C5         72.150      828.7020      490.373      0.22900     -0.05646       82.423     0.62952     0.27231        4.93849       0.27708        5.02513       227.40      0.23498     "Isopentane"             
  I-PENTANE      72.150      828.7020      490.373      0.22900     -0.05646       82.423     0.62952     0.27231        4.93849       0.27708        5.02513       227.40      0.23498     "Isopentane"             
  ISOPENTAN      72.150      828.7020      490.373      0.22900     -0.05646       82.423     0.62952     0.27231        4.93849       0.27708        5.02513       227.40      0.23498     "Isopentane"             
  N-C5           72.150      845.4600      488.777      0.25200     -0.02928       97.136     0.63585     0.26837        4.98174       0.26834        4.98112       231.00      0.23558     "Pentane"                
  N-PENTANE      72.150      845.4600      488.777      0.25200     -0.02928       97.136     0.63585     0.26837        4.98174       0.26834        4.98112       231.00      0.23558     "Pentane"                
  PENTANE        72.150      845.4600      488.777      0.25200     -0.02928       97.136     0.63585     0.26837        4.98174       0.26834        4.98112       231.00      0.23558     "Pentane"                
  C-C5           70.134      920.8800      653.830      0.19669     -0.07568      120.614     0.74932     0.27554        4.16480       0.28986        4.38110       203.00      0.46154     "Cyclopentane"           
  CYCLO-C5       70.134      920.8800      653.830      0.19669     -0.07568      120.614     0.74932     0.27554        4.16480       0.28986        4.38110       203.00      0.46154     "Cyclopentane"           
  C-PENTANE      70.134      920.8800      653.830      0.19669     -0.07568      120.614     0.74932     0.27554        4.16480       0.28986        4.38110       203.00      0.46154     "Cyclopentane"           
  CYCLOPENT      70.134      920.8800      653.830      0.19669     -0.07568      120.614     0.74932     0.27554        4.16480       0.28986        4.38110       203.00      0.46154     "Cyclopentane"           
  22DM-C4        86.177      879.6600      446.716      0.23300     -0.07263      121.637     0.65312     0.27220        5.75223       0.27760        5.86625       263.00      0.26394     "2,2-Dimethylbutane"     
  22DM-BUTA      86.177      879.6600      446.716      0.23300     -0.07263      121.637     0.65312     0.27220        5.75223       0.27760        5.86625       263.00      0.26394     "2,2-Dimethylbutane"     
  23DM-C4        86.177      899.8200      453.968      0.24800     -0.05339      136.489     0.66541     0.26929        5.72820       0.27419        5.83236       263.40      0.29290     "2,3-Dimethylbutane"     
  23DM-BUTA      86.177      899.8200      453.968      0.24800     -0.05339      136.489     0.66541     0.26929        5.72820       0.27419        5.83236       263.40      0.29290     "2,3-Dimethylbutane"     
  2M-C5          86.177      895.5000      436.564      0.27800     -0.02956      140.585     0.65696     0.26684        5.87397       0.26916        5.92513       268.80      0.29235     "2-Methylpentane"        
  2M-PENTAN      86.177      895.5000      436.564      0.27800     -0.02956      140.585     0.65696     0.26684        5.87397       0.26916        5.92513       268.80      0.29235     "2-Methylpentane"        
  3M-C5          86.177      907.9200      452.518      0.27300     -0.04127      146.058     0.66801     0.27281        5.87397       0.27183        5.85300       267.40      0.30930     "3-Methylpentane"        
  3M-PENTAN      86.177      907.9200      452.518      0.27300     -0.04127      146.058     0.66801     0.27281        5.87397       0.27183        5.85300       267.40      0.30930     "3-Methylpentane"        
  N-C6           86.177      913.6800      438.739      0.30000     -0.01176      155.884     0.66304     0.26377        5.89479       0.26594        5.94347       271.00      0.32245     "Hexane"                 
  N-HEXANE       86.177      913.6800      438.739      0.30000     -0.01176      155.884     0.66304     0.26377        5.89479       0.26594        5.94347       271.00      0.32245     "Hexane"                 
  HEXANE         86.177      913.6800      438.739      0.30000     -0.01176      155.884     0.66304     0.26377        5.89479       0.26594        5.94347       271.00      0.32245     "Hexane"                 
  MC-C5          84.161      959.0220      548.823      0.22700     -0.05007      160.571     0.75215     0.27249        5.10989       0.28473        5.33948       243.00      0.53135     "Methylcyclopentane"     
  MC-PENTAN      84.161      959.0220      548.823      0.22700     -0.05007      160.571     0.75215     0.27249        5.10989       0.28473        5.33948       243.00      0.53135     "Methylcyclopentane"     
  22DM-C5       100.204      936.7200      401.755      0.28700     -0.03965      174.633     0.67721     0.26619        6.66048       0.27298        6.83025       305.90      0.35278     "2,2-Dimethylpentane"    
  22DM-PENT     100.204      936.7200      401.755      0.28700     -0.03965      174.633     0.67721     0.26619        6.66048       0.27298        6.83025       305.90      0.35278     "2,2-Dimethylpentane"    
  BENZENE        78.114     1011.6900      709.960      0.21000     -0.02879      175.600     0.88238     0.26815        4.10073       0.28034        4.28713       205.10      0.69219     "Benzene"                
  24DM-C5       100.204      935.4600      397.403      0.30400     -0.03227      177.069     0.67596     0.26474        6.68771       0.27137        6.85522       306.60      0.35566     "2,4-Dimethylpentane"    
  24DM-PENT     100.204      935.4600      397.403      0.30400     -0.03227      177.069     0.67596     0.26474        6.68771       0.27137        6.85522       306.60      0.35566     "2,4-Dimethylpentane"    
  C-C6           84.161      996.3000      590.739      0.21100     -0.05688      177.102     0.78173     0.27259        4.93369       0.30244        5.47386       240.80      1.05399     "Cyclohexane"            
  CYCLO-C6       84.161      996.3000      590.739      0.21100     -0.05688      177.102     0.78173     0.27259        4.93369       0.30244        5.47386       240.80      1.05399     "Cyclohexane"            
  C-HEXANE       84.161      996.3000      590.739      0.21100     -0.05688      177.102     0.78173     0.27259        4.93369       0.30244        5.47386       240.80      1.05399     "Cyclohexane"            
  CYCLOHEXA      84.161      996.3000      590.739      0.21100     -0.05688      177.102     0.78173     0.27259        4.93369       0.30244        5.47386       240.80      1.05399     "Cyclohexane"            
  223TM-C4      100.204      955.9800      427.861      0.25000     -0.06542      177.672     0.69312     0.26562        6.36894       0.27908        6.69174       299.00      0.37505     "2,2,3-Trimethylbutane"  
  223TM-BUT     100.204      955.9800      427.861      0.25000     -0.06542      177.672     0.69312     0.26562        6.36894       0.27908        6.69174       299.00      0.37505     "2,2,3-Trimethylbutane"  
  33DM-C5       100.204      965.3400      427.861      0.26900     -0.05362      187.140     0.69652     0.27396        6.63325       0.27697        6.70607       303.00      0.39761     "3,3-Dimethylpentane"    
  33DM-PENT     100.204      965.3400      427.861      0.26900     -0.05362      187.140     0.69652     0.27396        6.63325       0.27697        6.70607       303.00      0.39761     "3,3-Dimethylpentane"    
  23DM-C5       100.204      967.1400      422.060      0.29700     -0.03652      193.792     0.69816     0.25600        6.29526       0.27360        6.72825       303.40      0.41384     "2,3-Dimethylpentane"    
  23DM-PENT     100.204      967.1400      422.060      0.29700     -0.03652      193.792     0.69816     0.25600        6.29526       0.27360        6.72825       303.40      0.41384     "2,3-Dimethylpentane"    
  2M-C6         100.204      954.1800      395.953      0.33100     -0.00490      194.166     0.68180     0.26077        6.74377       0.26630        6.88687       308.80      0.39610     "2-Methylhexane"         
  2M-HEXANE     100.204      954.1800      395.953      0.33100     -0.00490      194.166     0.68180     0.26077        6.74377       0.26630        6.88687       308.80      0.39610     "2-Methylhexane"         
  3M-C6         100.204      963.3600      407.556      0.32300     -0.01535      197.464     0.69023     0.25512        6.47146       0.26894        6.82207       307.40      0.41332     "3-Methylhexane"         
  3M-HEXANE     100.204      963.3600      407.556      0.32300     -0.01535      197.464     0.69023     0.25512        6.47146       0.26894        6.82207       307.40      0.41332     "3-Methylhexane"         
  3E-C5         100.204      972.9000      419.159      0.31100     -0.01984      200.354     0.70125     0.26739        6.66048       0.27042        6.73596       305.00      0.43230     "3-Ethylpentane"         
  3E-PENTAN     100.204      972.9000      419.159      0.31100     -0.01984      200.354     0.70125     0.26739        6.66048       0.27042        6.73596       305.00      0.43230     "3-Ethylpentane"         
  N-C7          100.204      972.3600      397.403      0.35000      0.01233      209.267     0.68672     0.26110        6.85590       0.26320        6.91102       311.00      0.43539     "Heptane"                
  N-HEPTANE     100.204      972.3600      397.403      0.35000      0.01233      209.267     0.68672     0.26110        6.85590       0.26320        6.91102       311.00      0.43539     "Heptane"                
  HEPTANE       100.204      972.3600      397.403      0.35000      0.01233      209.267     0.68672     0.26110        6.85590       0.26320        6.91102       311.00      0.43539     "Heptane"                
  MC-C6          98.188     1029.9420      503.426      0.23500     -0.03843      213.515     0.77222     0.26849        5.89479       0.28729        6.30746       280.80      0.78245     "Methylcyclohexane"      
  MC-HEXANE      98.188     1029.9420      503.426      0.23500     -0.03843      213.515     0.77222     0.26849        5.89479       0.28729        6.30746       280.80      0.78245     "Methylcyclohexane"      
  EC-C5          98.188     1025.1000      492.693      0.27000     -0.02627      218.230     0.76936     0.26903        6.00692       0.27317        6.09939       283.00      0.53539     "Ethylcyclopentane"      
  EC-PENTAN      98.188     1025.1000      492.693      0.27000     -0.02627      218.230     0.76936     0.26903        6.00692       0.27317        6.09939       283.00      0.53539     "Ethylcyclopentane"      
  TOLUENE        92.141     1065.1500      595.815      0.26400      0.00394      231.222     0.86987     0.26384        5.06183       0.26667        5.11615       245.10      0.64614     "Toluene"                
  C-C7           98.188     1087.7400      556.945      0.24200     -0.04795      245.908     0.81331     0.27437        5.75063       0.27896        5.84690       280.00      0.65213     "Cycloheptane"           
  CYCLO-C7       98.188     1087.7400      556.945      0.24200     -0.04795      245.908     0.81331     0.27437        5.75063       0.27896        5.84690       280.00      0.65213     "Cycloheptane"           
  C-HEPTANE      98.188     1087.7400      556.945      0.24200     -0.04795      245.908     0.81331     0.27437        5.75063       0.27896        5.84690       280.00      0.65213     "Cycloheptane"           
  CYCLOHEPT      98.188     1087.7400      556.945      0.24200     -0.04795      245.908     0.81331     0.27437        5.75063       0.27896        5.84690       280.00      0.65213     "Cycloheptane"           
  N-C8          114.231     1023.6600      361.144      0.39900      0.03916      258.150     0.70513     0.25909        7.88108       0.26013        7.91281       351.00      0.57892     "Octane"                 
  N-OCTANE      114.231     1023.6600      361.144      0.39900      0.03916      258.150     0.70513     0.25909        7.88108       0.26013        7.91281       351.00      0.57892     "Octane"                 
  OCTANE        114.231     1023.6600      361.144      0.39900      0.03916      258.150     0.70513     0.25909        7.88108       0.26013        7.91281       351.00      0.57892     "Octane"                 
  E-BENZENE     106.167     1110.8700      523.441      0.30400      0.02183      277.351     0.86960     0.26305        5.99091       0.26254        5.97927       285.10      0.72363     "Ethylbenzene"           
  P-XYLENE      106.167     1109.1600      509.227      0.32200      0.04121      281.404     0.86371     0.25904        6.05498       0.25525        5.96647       285.10      0.65065     "p-Xylene"               
  M-XYLENE      106.167     1110.6000      513.579      0.32700      0.03650      282.706     0.86686     0.25884        6.00692       0.25621        5.94581       285.10      0.65532     "m-Xylene"               
  O-XYLENE      106.167     1134.5400      541.281      0.31200      0.01858      292.292     0.88238     0.26349        5.92683       0.26623        5.98852       285.10      0.86923     "o-Xylene"               
  N-C9          128.258     1070.2800      332.136      0.44500      0.05908      303.239     0.71982     0.25708        8.89025       0.25830        8.93253       391.00      0.75172     "Nonane"                 
  N-NONANE      128.258     1070.2800      332.136      0.44500      0.05908      303.239     0.71982     0.25708        8.89025       0.25830        8.93253       391.00      0.75172     "Nonane"                 
  NONANE        128.258     1070.2800      332.136      0.44500      0.05908      303.239     0.71982     0.25708        8.89025       0.25830        8.93253       391.00      0.75172     "Nonane"                 
  C-C8          112.215     1164.9600      517.785      0.25400     -0.02118      303.794     0.83814     0.27201        6.56757       0.27773        6.70579       320.00      0.92258     "Cyclooctane"            
  CYCLO-C8      112.215     1164.9600      517.785      0.25400     -0.02118      303.794     0.83814     0.27201        6.56757       0.27773        6.70579       320.00      0.92258     "Cyclooctane"            
  C-OCTANE      112.215     1164.9600      517.785      0.25400     -0.02118      303.794     0.83814     0.27201        6.56757       0.27773        6.70579       320.00      0.92258     "Cyclooctane"            
  CYCLOOCTA     112.215     1164.9600      517.785      0.25400     -0.02118      303.794     0.83814     0.27201        6.56757       0.27773        6.70579       320.00      0.92258     "Cyclooctane"            
  CUMENE        120.194     1135.8000      465.426      0.32600      0.02462      306.195     0.86411     0.26589        6.96323       0.26435        6.92291       322.90      0.83587     "Cumene"                 
  I-C3-BENZ     120.194     1135.8000      465.426      0.32600      0.02462      306.195     0.86411     0.26589        6.96323       0.26435        6.92291       322.90      0.83587     "Cumene"                 
  1ME-BENZE     120.194     1135.8000      465.426      0.32600      0.02462      306.195     0.86411     0.26589        6.96323       0.26435        6.92291       322.90      0.83587     "Cumene"                 
  P-BENZENE     120.194     1149.0300      464.121      0.34500      0.03545      318.804     0.86377     0.26528        7.04812       0.26584        7.06298       325.10      1.02704     "Propylbenzene"          
  1E4M-BENZ     120.194     1152.3600      468.472      0.36400      0.02687      323.813     0.86442     0.26700        7.04812       0.26791        7.07222       325.10      1.05666     "1-Ethyl-4-methylbenzene"
  135TM-BEN     120.194     1147.1400      453.533      0.39900      0.03235      328.539     0.84675     0.25376        6.88794       0.26674        7.24046       325.10      1.06804     "1,3,5-Trimethylbenzene" 
  124TM-BEN     120.194     1168.3800      468.762      0.37700      0.05504      336.977     0.87913     0.26050        6.96803       0.26206        7.00966       325.10      1.15251     "1,2,4-Trimethylbenzene" 
  N-C10         142.285     1111.8600      306.030      0.49000      0.08100      344.999     0.73183     0.25636        9.99552       0.25577        9.97248       431.00      0.95637     "Decane"                 
  N-DECANE      142.285     1111.8600      306.030      0.49000      0.08100      344.999     0.73183     0.25636        9.99552       0.25577        9.97248       431.00      0.95637     "Decane"                 
  DECANE        142.285     1111.8600      306.030      0.49000      0.08100      344.999     0.73183     0.25636        9.99552       0.25577        9.97248       431.00      0.95637     "Decane"                 
  123TM-BEN     120.194     1196.1000      500.960      0.36700      0.02813      349.261     0.89786     0.27195        6.96803       0.26888        6.88956       325.10      1.25226     "1,2,3-Trimethylbenzene" 
  N-C11         156.312     1150.2000      287.175      0.53700      0.08813      383.758     0.74181     0.25677       11.03672       0.25643       11.02206       471.00      1.19634     "Undecane"               
  N-UNDECAN     156.312     1150.2000      287.175      0.53700      0.08813      383.758     0.74181     0.25677       11.03672       0.25643       11.02206       471.00      1.19634     "Undecane"               
  UNDECANE      156.312     1150.2000      287.175      0.53700      0.08813      383.758     0.74181     0.25677       11.03672       0.25643       11.02206       471.00      1.19634     "Undecane"               
  N-C12         170.338     1184.4000      263.969      0.57600      0.11898      420.265     0.75030     0.25083       12.07792       0.25135       12.10265       511.00      1.47530     "Dodecane"               
  N-DODECAN     170.338     1184.4000      263.969      0.57600      0.11898      420.265     0.75030     0.25083       12.07792       0.25135       12.10265       511.00      1.47530     "Dodecane"               
  DODECANE      170.338     1184.4000      263.969      0.57600      0.11898      420.265     0.75030     0.25083       12.07792       0.25135       12.10265       511.00      1.47530     "Dodecane"               
  NAPHTHALE     128.174     1347.1200      587.403      0.30400      0.03554      424.785     1.01736     0.26490        6.51951       0.27752        6.83010       311.10      2.63165     "Naphthalene"            
  N-C13         184.365     1215.0000      243.663      0.61800      0.14683      454.458     0.75766     0.24636       13.18320       0.24663       13.19765       551.00      1.79657     "Tridecane"              
  N-TRIDECA     184.365     1215.0000      243.663      0.61800      0.14683      454.458     0.75766     0.24636       13.18320       0.24663       13.19765       551.00      1.79657     "Tridecane"              
  TRIDECANE     184.365     1215.0000      243.663      0.61800      0.14683      454.458     0.75766     0.24636       13.18320       0.24663       13.19765       551.00      1.79657     "Tridecane"              
  2M-NAPHTH     142.200     1369.8000      513.434      0.37400      0.05748      466.201     0.99853     0.25848        7.40053       0.27072        7.75086       351.10      2.65690     "2-Methylnaphthalene"    
  1M-NAPHTH     142.200     1389.6000      522.136      0.34800      0.08002      472.537     1.02350     0.25912        7.40053       0.26566        7.58751       351.10      2.79963     "1-Methylnaphthalene"    
  N-C14         198.392     1247.4000      227.709      0.64400      0.16829      487.403     0.76400     0.24360       14.32051       0.24331       14.30360       591.00      2.16495     "Tetradecane"            
  N-TETRADE     198.392     1247.4000      227.709      0.64400      0.16829      487.403     0.76400     0.24360       14.32051       0.24331       14.30360       591.00      2.16495     "Tetradecane"            
  TETRADECA     198.392     1247.4000      227.709      0.64400      0.16829      487.403     0.76400     0.24360       14.32051       0.24331       14.30360       591.00      2.16495     "Tetradecane"            
  DPH-C1        168.238     1368.0000      393.052      0.48100      0.15575      507.540     1.00924     0.24145        9.01839       0.25002        9.33839       419.20      3.53425     "Diphenylmethane"        
  DPH-METHA     168.238     1368.0000      393.052      0.48100      0.15575      507.540     1.00924     0.24145        9.01839       0.25002        9.33839       419.20      3.53425     "Diphenylmethane"        
  N-C15         212.419     1274.4000      214.656      0.68500      0.18067      517.541     0.76953     0.24287       15.47384       0.24200       15.41826       631.00      2.58102     "Pentadecane"            
  N-PENTADE     212.419     1274.4000      214.656      0.68500      0.18067      517.541     0.76953     0.24287       15.47384       0.24200       15.41826       631.00      2.58102     "Pentadecane"            
  PENTADECA     212.419     1274.4000      214.656      0.68500      0.18067      517.541     0.76953     0.24287       15.47384       0.24200       15.41826       631.00      2.58102     "Pentadecane"            
  N-C16         226.446     1301.4000      203.053      0.71800      0.19316      546.620     0.77442     0.24081       16.56309       0.24055       16.54484       671.00      3.04902     "Hexadecane"             
  N-HEXADEC     226.446     1301.4000      203.053      0.71800      0.19316      546.620     0.77442     0.24081       16.56309       0.24055       16.54484       671.00      3.04902     "Hexadecane"             
  HEXADECAN     226.446     1301.4000      203.053      0.71800      0.19316      546.620     0.77442     0.24081       16.56309       0.24055       16.54484       671.00      3.04902     "Hexadecane"             
  N-C17         240.473     1324.8000      194.351      0.75300      0.19587      572.259     0.77891     0.24153       17.66837       0.24146       17.66316       711.00      3.54785     "Heptadecane"            
  N-HEPTADE     240.473     1324.8000      194.351      0.75300      0.19587      572.259     0.77891     0.24153       17.66837       0.24146       17.66316       711.00      3.54785     "Heptadecane"            
  HEPTADECA     240.473     1324.8000      194.351      0.75300      0.19587      572.259     0.77891     0.24153       17.66837       0.24146       17.66316       711.00      3.54785     "Heptadecane"            
  N-C18         254.500     1344.6000      187.099      0.80000      0.19379      595.855     0.78325     0.24695       19.04595       0.24352       18.78076       751.00      4.09877     "Octadecane"             
  N-OCTADEC     254.500     1344.6000      187.099      0.80000      0.19379      595.855     0.78325     0.24695       19.04595       0.24352       18.78076       751.00      4.09877     "Octadecane"             
  OCTADECAN     254.500     1344.6000      187.099      0.80000      0.19379      595.855     0.78325     0.24695       19.04595       0.24352       18.78076       751.00      4.09877     "Octadecane"             
  N-C19         268.527     1359.0000      168.244      0.84500      0.24761      620.837     0.78655     0.21375       18.52896       0.23068       19.99651       791.00      4.73795     "Nonadecane"             
  N-NONADEC     268.527     1359.0000      168.244      0.84500      0.24761      620.837     0.78655     0.21375       18.52896       0.23068       19.99651       791.00      4.73795     "Nonadecane"             
  NONADECAN     268.527     1359.0000      168.244      0.84500      0.24761      620.837     0.78655     0.21375       18.52896       0.23068       19.99651       791.00      4.73795     "Nonadecane"             
  12DPH-BEN     230.309     1542.6000      433.663      0.52042     -0.30612      629.600     0.91020     0.23288        8.89001       0.38311       14.62482       553.30      6.67159     "1,2-Diphenylbenzene"    
  PHENANTHR     178.233     1564.2000      416.258      0.47900      0.12838      640.437     0.97699     0.22006        8.87423       0.26603       10.72814       417.10      7.30912     "Phenanthrene"           
  ANTHRACEN     178.233     1564.7400      416.258      0.50100      0.35376      645.226     1.29009     0.21998        8.87423       0.20016        8.07440       417.10      6.68134     "Anthracene"             
  N-C20         282.554     1382.4000      155.190      0.86500      0.28236      648.552     0.78655     0.20917       19.99531       0.22265       21.28414       831.00      5.43200     "Eicosane"               
  N-EICOSAN     282.554     1382.4000      155.190      0.86500      0.28236      648.552     0.78655     0.20917       19.99531       0.22265       21.28414       831.00      5.43200     "Eicosane"               
  EICOSANE      282.554     1382.4000      155.190      0.86500      0.28236      648.552     0.78655     0.20917       19.99531       0.22265       21.28414       831.00      5.43200     "Eicosane"               
  N-C21         296.580     1400.4000      149.389      0.94773      0.28147      673.700     0.78752     0.20523       20.64563       0.22372       22.50586       871.00      6.15049     "Heneicosane"            
  N-HENEICO     296.580     1400.4000      149.389      0.94773      0.28147      673.700     0.78752     0.20523       20.64563       0.22372       22.50586       871.00      6.15049     "Heneicosane"            
  HENEICOSA     296.580     1400.4000      149.389      0.94773      0.28147      673.700     0.78752     0.20523       20.64563       0.22372       22.50586       871.00      6.15049     "Heneicosane"            
  13DPH-BEN     230.309     1589.4000      359.694      0.54673      0.04334      685.400     0.98848     0.24457       11.59737       0.29493       13.98551       553.30     10.18562     "1,3-Diphenylbenzene"    
  N-C22         310.607     1414.8000      142.137      1.01781      0.29056      695.480     0.78896     0.20155       21.52916       0.22219       23.73433       911.00      6.93370     "Docosane"               
  N-DOCOSAN     310.607     1414.8000      142.137      1.01781      0.29056      695.480     0.78896     0.20155       21.52916       0.22219       23.73433       911.00      6.93370     "Docosane"               
  DOCOSANE      310.607     1414.8000      142.137      1.01781      0.29056      695.480     0.78896     0.20155       21.52916       0.22219       23.73433       911.00      6.93370     "Docosane"               
  14DPH-BEN     230.309     1634.4000      433.663      0.59477     -0.09594      708.800     1.02275     0.28872       11.67746       0.33530       13.56146       553.30     12.06661     "1,4-Diphenylbenzene"    
  N-C23         324.634     1422.0000      133.435      1.14967      0.31066      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  N-TRICOSA     324.634     1422.0000      133.435      1.14967      0.31066      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  TRICOSANE     324.634     1422.0000      133.435      1.14967      0.31066      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  N-C24         338.661     1440.0000      126.183      1.15026      0.32510      736.340     0.79111     0.19430       23.79614       0.21438       26.25435       991.00      8.66387     "Tetracosane"            
  N-TETRACO     338.661     1440.0000      126.183      1.15026      0.32510      736.340     0.79111     0.19430       23.79614       0.21438       26.25435       991.00      8.66387     "Tetracosane"            
  TETRACOSA     338.661     1440.0000      126.183      1.15026      0.32510      736.340     0.79111     0.19430       23.79614       0.21438       26.25435       991.00      8.66387     "Tetracosane"            
END
set xlabel "Molecular Weight"
set ylabel "Critical Temperature (R)"
set output "Figures/Table_002_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:3 with points notitle
set ylabel "Critical Pressure (psia)"
set output "Figures/Table_002_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:4 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_002_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:5 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_002_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:6 with points notitle
set ylabel "Boiling Temperature (F)"
set output "Figures/Table_002_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:7 with points notitle
set ylabel "Specific Gravity"
set output "Figures/Table_002_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:8 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_002_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:9 with points notitle
set ylabel "Critical Volume (ft3/lbmol)"
set output "Figures/Table_002_VC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:10 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_002_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:11 with points notitle
set ylabel "Viscosity Vc (ft3/lbmol)"
set output "Figures/Table_002_VISV_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:12 with points notitle
set ylabel "Parachor"
set output "Figures/Table_002_PCHOR_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:13 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_002_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:14 with points notitle

set title "EOS Fluid Characterization \"SRK Library\""
show title

$Expt << END
#                               Tc           Pc                                     Tb                                     Vc                          VcVis                     Visc                    
# Component        MW          (R)         (psia)         AF          VTran         (F)          SG          Zc        (ft3/lbmol)      ZcVis       (ft3/lbmol)      Pchor       (cp)                  Full
#-----------   ---------   -----------   ----------   ----------   ----------   ----------   ---------   ---------   --------------   ---------   --------------   --------   ----------   ---------------------------
  HE              4.003        9.3420       32.924     -0.39000     -0.04307     -452.122     0.06253     0.30142        0.91786       0.30142        0.91786        19.20          NaN     "Helium"                 
  HELIUM          4.003        9.3420       32.924     -0.39000     -0.04307     -452.122     0.06253     0.30142        0.91786       0.30142        0.91786        19.20          NaN     "Helium"                 
  NE             20.180       79.9200      400.304     -0.01600     -0.13988     -410.523     0.43717     0.31177        0.66797       0.31177        0.66797        41.30          NaN     "Neon"                   
  NEON           20.180       79.9200      400.304     -0.01600     -0.13988     -410.523     0.43717     0.31177        0.66797       0.31177        0.66797        41.30          NaN     "Neon"                   
  AR             39.948      271.5480      710.395     -0.00200     -0.02102     -302.083     0.46589     0.29119        1.19450       0.29119        1.19450        74.70          NaN     "Argon"                  
  ARGON          39.948      271.5480      710.395     -0.00200     -0.02102     -302.083     0.46589     0.29119        1.19450       0.29119        1.19450        74.70          NaN     "Argon"                  
  KR             83.800      376.9200      797.708     -0.00723      0.00686     -244.138     0.79637     0.28810        1.46088       0.28810        1.46088       148.80          NaN     "Krypton"                
  KRYPTON        83.800      376.9200      797.708     -0.00723      0.00686     -244.138     0.79637     0.28810        1.46088       0.28810        1.46088       148.80          NaN     "Krypton"                
  XE            131.290      521.5320      847.020     -0.00238      0.06428     -162.652     1.13954     0.28606        1.89018       0.28606        1.89018       229.00          NaN     "Xenon"                  
  XENON         131.290      521.5320      847.020     -0.00238      0.06428     -162.652     1.13954     0.28606        1.89018       0.28606        1.89018       229.00          NaN     "Xenon"                  
  RN            222.018      678.6000      913.738     -0.03344      0.09444      -82.030     3.56414     0.28138        2.24258       0.28138        2.24258       382.30          NaN     "Radon"                  
  RADON         222.018      678.6000      913.738     -0.03344      0.09444      -82.030     3.56414     0.28138        2.24258       0.28138        2.24258       382.30          NaN     "Radon"                  
  H2              2.016       59.3640      187.534     -0.21700     -0.16512     -422.865     0.02737     0.30273        1.02839       0.30273        1.02839        35.00          NaN     "Hydrogen"               
  HYDROGEN        2.016       59.3640      187.534     -0.21700     -0.16512     -422.865     0.02737     0.30273        1.02839       0.30273        1.02839        35.00          NaN     "Hydrogen"               
  N2             28.014      227.1600      492.838      0.03700     -0.00090     -320.262     0.27236     0.29178        1.44326       0.29178        1.44326        59.10          NaN     "Nitrogen"               
  NITROGEN       28.014      227.1600      492.838      0.03700     -0.00090     -320.262     0.27236     0.29178        1.44326       0.29178        1.44326        59.10          NaN     "Nitrogen"               
  CO             28.010      239.1300      506.762      0.04500      0.01709     -312.900     0.26725     0.29449        1.49132       0.29449        1.49132        61.70          NaN     "Carbon Monoxide"        
  O2             31.999      278.2440      731.425      0.01644      0.01030     -297.364     0.37805     0.28789        1.17527       0.28789        1.17527        53.10          NaN     "Oxygen"                 
  OXYGEN         31.999      278.2440      731.425      0.01644      0.01030     -297.364     0.37805     0.28789        1.17527       0.28789        1.17527        53.10          NaN     "Oxygen"                 
  NO             30.006      324.0000      939.845      0.58200      0.07687     -241.474     0.39809     0.25113        0.92907       0.25113        0.92907        56.60          NaN     "Nitric Oxide"           
  N2O            44.013      557.2800     1052.249      0.16115      0.08019     -127.264     0.71876     0.27338        1.55379       0.27338        1.55379        41.30          NaN     "Nitrous Oxide"          
  CO2            44.010      547.4160     1069.508      0.22500      0.21749     -126.348     0.75104     0.27433        1.50686       0.27433        1.50686        80.00          NaN     "Carbon Dioxide"         
  H2S            34.082      672.1200     1299.973      0.09000      0.10153      -77.321     0.80854     0.28292        1.56981       0.28292        1.56981        80.10          NaN     "Hydrogen Sulfide"       
  NH3            17.031      729.7200     1646.613      0.25700      0.25512      -26.620     0.60187     0.24409        1.16086       0.24409        1.16086        58.00          NaN     "Ammonia"                
  AMMONIA        17.031      729.7200     1646.613      0.25700      0.25512      -26.620     0.60187     0.24409        1.16086       0.24409        1.16086        58.00          NaN     "Ammonia"                
  SO2            64.065      775.4400     1143.478      0.25239      0.12583       13.964     1.38209     0.26853        1.95425       0.26853        1.95425       127.30          NaN     "Sulfur Dioxide"         
  NO2            46.006      775.8000     1464.881      0.83400      0.19248       70.184     1.46495     0.47294        2.68790       0.22019        1.25141        72.80      0.22195     "Nitrogen Dioxide"       
  N2O4           92.011      775.8180     1464.881      1.00700     -0.86109       83.416     1.45474     0.47067        2.67508       0.43957        2.49831       145.60      0.30050     "Nitrogen Tetroxide"     
  H2O            18.015     1164.8520     3200.113      0.34400      0.27319      216.288     1.00653     0.22943        0.89623       0.22731        0.88793        52.80      1.12658     "Water"                  
  WATER          18.015     1164.8520     3200.113      0.34400      0.27319      216.288     1.00653     0.22943        0.89623       0.22731        0.88793        52.80      1.12658     "Water"                  
  C1             16.043      343.0080      667.029      0.01100     -0.00247     -258.104     0.13975     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  CH4            16.043      343.0080      667.029      0.01100     -0.00247     -258.104     0.13975     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  METHANE        16.043      343.0080      667.029      0.01100     -0.00247     -258.104     0.13975     0.28620        1.57942       0.28620        1.57942        71.00          NaN     "Methane"                
  C2             30.070      549.5760      706.624      0.09900      0.05894     -126.959     0.31005     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  C2H6           30.070      549.5760      706.624      0.09900      0.05894     -126.959     0.31005     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  ETHANE         30.070      549.5760      706.624      0.09900      0.05894     -126.959     0.31005     0.27924        2.33069       0.27924        2.33069       111.00          NaN     "Ethane"                 
  C3             44.097      665.6940      616.120      0.15200      0.09075      -43.429     0.49895     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  C3H8           44.097      665.6940      616.120      0.15200      0.09075      -43.429     0.49895     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  PROPANE        44.097      665.6940      616.120      0.15200      0.09075      -43.429     0.49895     0.27630        3.20369       0.27630        3.20369       151.00          NaN     "Propane"                
  C-C3           42.081      716.8500      808.585      0.13000     -0.14761      -26.402     0.52573     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  CYCLO-C3       42.081      716.8500      808.585      0.13000     -0.14761      -26.402     0.52573     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  C-PROPANE      42.081      716.8500      808.585      0.13000     -0.14761      -26.402     0.52573     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  CYCLOPROP      42.081      716.8500      808.585      0.13000     -0.14761      -26.402     0.52573     0.27410        2.60781       0.27410        2.60781       132.00          NaN     "Cyclopropane"           
  I-C4           58.123      734.1300      527.937      0.18600      0.10952       11.412     0.57258     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  ISO-C4         58.123      734.1300      527.937      0.18600      0.10952       11.412     0.57258     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  I-BUTANE       58.123      734.1300      527.937      0.18600      0.10952       11.412     0.57258     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  ISOBUTANE      58.123      734.1300      527.937      0.18600      0.10952       11.412     0.57258     0.28199        4.20805       0.28199        4.20805       188.80          NaN     "Isobutane"              
  N-C4           58.123      765.2160      550.563      0.20000      0.11028       31.469     0.59254     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  N-BUTANE       58.123      765.2160      550.563      0.20000      0.11028       31.469     0.59254     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  BUTANE         58.123      765.2160      550.563      0.20000      0.11028       31.469     0.59254     0.27385        4.08471       0.27385        4.08471       191.00          NaN     "Butane"                 
  NEO-C5         72.150      780.7500      463.976      0.19700      0.08765       49.346     0.60388     0.26895        4.85680       0.26895        4.85680       225.90          NaN     "Neopentane"             
  NEOPENTAN      72.150      780.7500      463.976      0.19700      0.08765       49.346     0.60388     0.26895        4.85680       0.26895        4.85680       225.90          NaN     "Neopentane"             
  C-C4           56.108      828.0000      723.738      0.18500      0.06922       55.766     0.70188     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  CYCLO-C4       56.108      828.0000      723.738      0.18500      0.06922       55.766     0.70188     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  C-BUTANE       56.108      828.0000      723.738      0.18500      0.06922       55.766     0.70188     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  CYCLOBUTA      56.108      828.0000      723.738      0.18500      0.06922       55.766     0.70188     0.28442        3.49203       0.28442        3.49203       166.00          NaN     "Cyclobutane"            
  I-C5           72.150      828.7020      490.373      0.22900      0.09772       82.698     0.63124     0.27231        4.93849       0.27633        5.01142       227.40      0.23498     "Isopentane"             
  ISO-C5         72.150      828.7020      490.373      0.22900      0.09772       82.698     0.63124     0.27231        4.93849       0.27633        5.01142       227.40      0.23498     "Isopentane"             
  I-PENTANE      72.150      828.7020      490.373      0.22900      0.09772       82.698     0.63124     0.27231        4.93849       0.27633        5.01142       227.40      0.23498     "Isopentane"             
  ISOPENTAN      72.150      828.7020      490.373      0.22900      0.09772       82.698     0.63124     0.27231        4.93849       0.27633        5.01142       227.40      0.23498     "Isopentane"             
  N-C5           72.150      845.4600      488.777      0.25200      0.11947       97.371     0.63753     0.26837        4.98174       0.26763        4.96794       231.00      0.23558     "Pentane"                
  N-PENTANE      72.150      845.4600      488.777      0.25200      0.11947       97.371     0.63753     0.26837        4.98174       0.26763        4.96794       231.00      0.23558     "Pentane"                
  PENTANE        72.150      845.4600      488.777      0.25200      0.11947       97.371     0.63753     0.26837        4.98174       0.26763        4.96794       231.00      0.23558     "Pentane"                
  C-C5           70.134      920.8800      653.830      0.19328      0.07272      120.614     0.75091     0.27554        4.16480       0.28924        4.37183       203.00      0.46154     "Cyclopentane"           
  CYCLO-C5       70.134      920.8800      653.830      0.19328      0.07272      120.614     0.75091     0.27554        4.16480       0.28924        4.37183       203.00      0.46154     "Cyclopentane"           
  C-PENTANE      70.134      920.8800      653.830      0.19328      0.07272      120.614     0.75091     0.27554        4.16480       0.28924        4.37183       203.00      0.46154     "Cyclopentane"           
  CYCLOPENT      70.134      920.8800      653.830      0.19328      0.07272      120.614     0.75091     0.27554        4.16480       0.28924        4.37183       203.00      0.46154     "Cyclopentane"           
  22DM-C4        86.177      879.6600      446.716      0.23300      0.07749      121.850     0.65465     0.27220        5.75223       0.27709        5.85551       263.00      0.26494     "2,2-Dimethylbutane"     
  22DM-BUTA      86.177      879.6600      446.716      0.23300      0.07749      121.850     0.65465     0.27220        5.75223       0.27709        5.85551       263.00      0.26494     "2,2-Dimethylbutane"     
  23DM-C4        86.177      899.8200      453.968      0.24800      0.09248      136.690     0.66691     0.26929        5.72820       0.27371        5.82211       263.40      0.29400     "2,3-Dimethylbutane"     
  23DM-BUTA      86.177      899.8200      453.968      0.24800      0.09248      136.690     0.66691     0.26929        5.72820       0.27371        5.82211       263.40      0.29400     "2,3-Dimethylbutane"     
  2M-C5          86.177      895.5000      436.564      0.27800      0.11345      140.714     0.65847     0.26684        5.87397       0.26869        5.91462       268.80      0.29355     "2-Methylpentane"        
  2M-PENTAN      86.177      895.5000      436.564      0.27800      0.11345      140.714     0.65847     0.26684        5.87397       0.26869        5.91462       268.80      0.29355     "2-Methylpentane"        
  3M-C5          86.177      907.9200      452.518      0.27300      0.10199      146.222     0.66948     0.27281        5.87397       0.27137        5.84293       267.40      0.31048     "3-Methylpentane"        
  3M-PENTAN      86.177      907.9200      452.518      0.27300      0.10199      146.222     0.66948     0.27281        5.87397       0.27137        5.84293       267.40      0.31048     "3-Methylpentane"        
  N-C6           86.177      913.6800      438.739      0.30000      0.12729      156.005     0.66451     0.26377        5.89479       0.26536        5.93039       271.00      0.32245     "Hexane"                 
  N-HEXANE       86.177      913.6800      438.739      0.30000      0.12729      156.005     0.66451     0.26377        5.89479       0.26536        5.93039       271.00      0.32245     "Hexane"                 
  HEXANE         86.177      913.6800      438.739      0.30000      0.12729      156.005     0.66451     0.26377        5.89479       0.26536        5.93039       271.00      0.32245     "Hexane"                 
  MC-C5          84.161      959.0220      548.823      0.22700      0.09134      160.985     0.75361     0.27249        5.10989       0.28418        5.32914       243.00      0.53135     "Methylcyclopentane"     
  MC-PENTAN      84.161      959.0220      548.823      0.22700      0.09134      160.985     0.75361     0.27249        5.10989       0.28418        5.32914       243.00      0.53135     "Methylcyclopentane"     
  22DM-C5       100.204      936.7200      401.755      0.28700      0.10079      174.696     0.67860     0.26619        6.66048       0.27256        6.81977       305.90      0.35429     "2,2-Dimethylpentane"    
  22DM-PENT     100.204      936.7200      401.755      0.28700      0.10079      174.696     0.67860     0.26619        6.66048       0.27256        6.81977       305.90      0.35429     "2,2-Dimethylpentane"    
  BENZENE        78.114     1011.6900      709.960      0.21000      0.10749      176.305     0.88392     0.26815        4.10073       0.27985        4.27964       205.10      0.69219     "Benzene"                
  24DM-C5       100.204      935.4600      397.403      0.30400      0.10707      177.114     0.67735     0.26474        6.68771       0.27096        6.84472       306.60      0.35722     "2,4-Dimethylpentane"    
  24DM-PENT     100.204      935.4600      397.403      0.30400      0.10707      177.114     0.67735     0.26474        6.68771       0.27096        6.84472       306.60      0.35722     "2,4-Dimethylpentane"    
  C-C6           84.161      996.3000      590.739      0.21100      0.08316      177.642     0.78312     0.27259        4.93369       0.30190        5.46416       240.80      1.05399     "Cyclohexane"            
  CYCLO-C6       84.161      996.3000      590.739      0.21100      0.08316      177.642     0.78312     0.27259        4.93369       0.30190        5.46416       240.80      1.05399     "Cyclohexane"            
  C-HEXANE       84.161      996.3000      590.739      0.21100      0.08316      177.642     0.78312     0.27259        4.93369       0.30190        5.46416       240.80      1.05399     "Cyclohexane"            
  CYCLOHEXA      84.161      996.3000      590.739      0.21100      0.08316      177.642     0.78312     0.27259        4.93369       0.30190        5.46416       240.80      1.05399     "Cyclohexane"            
  223TM-C4      100.204      955.9800      427.861      0.25000      0.07718      177.833     0.69445     0.26562        6.36894       0.27866        6.68155       299.00      0.37633     "2,2,3-Trimethylbutane"  
  223TM-BUT     100.204      955.9800      427.861      0.25000      0.07718      177.833     0.69445     0.26562        6.36894       0.27866        6.68155       299.00      0.37633     "2,2,3-Trimethylbutane"  
  33DM-C5       100.204      965.3400      427.861      0.26900      0.08665      187.273     0.69783     0.27396        6.63325       0.27655        6.69597       303.00      0.39893     "3,3-Dimethylpentane"    
  33DM-PENT     100.204      965.3400      427.861      0.26900      0.08665      187.273     0.69783     0.27396        6.63325       0.27655        6.69597       303.00      0.39893     "3,3-Dimethylpentane"    
  23DM-C5       100.204      967.1400      422.060      0.29700      0.10120      193.890     0.69948     0.25600        6.29526       0.27319        6.71807       303.40      0.41521     "2,3-Dimethylpentane"    
  23DM-PENT     100.204      967.1400      422.060      0.29700      0.10120      193.890     0.69948     0.25600        6.29526       0.27319        6.71807       303.40      0.41521     "2,3-Dimethylpentane"    
  2M-C6         100.204      954.1800      395.953      0.33100      0.12964      194.209     0.68315     0.26077        6.74377       0.26590        6.87655       308.80      0.39778     "2-Methylhexane"         
  2M-HEXANE     100.204      954.1800      395.953      0.33100      0.12964      194.209     0.68315     0.26077        6.74377       0.26590        6.87655       308.80      0.39778     "2-Methylhexane"         
  3M-C6         100.204      963.3600      407.556      0.32300      0.11984      197.529     0.69156     0.25512        6.47146       0.26853        6.81185       307.40      0.41488     "3-Methylhexane"         
  3M-HEXANE     100.204      963.3600      407.556      0.32300      0.11984      197.529     0.69156     0.25512        6.47146       0.26853        6.81185       307.40      0.41488     "3-Methylhexane"         
  3E-C5         100.204      972.9000      419.159      0.31100      0.11547      200.442     0.70257     0.26739        6.66048       0.27001        6.72573       305.00      0.43369     "3-Ethylpentane"         
  3E-PENTAN     100.204      972.9000      419.159      0.31100      0.11547      200.442     0.70257     0.26739        6.66048       0.27001        6.72573       305.00      0.43369     "3-Ethylpentane"         
  N-C7          100.204      972.3600      397.403      0.35000      0.14347      209.324     0.68803     0.26110        6.85590       0.26281        6.90093       311.00      0.43715     "Heptane"                
  N-HEPTANE     100.204      972.3600      397.403      0.35000      0.14347      209.324     0.68803     0.26110        6.85590       0.26281        6.90093       311.00      0.43715     "Heptane"                
  HEPTANE       100.204      972.3600      397.403      0.35000      0.14347      209.324     0.68803     0.26110        6.85590       0.26281        6.90093       311.00      0.43715     "Heptane"                
  MC-C6          98.188     1029.9420      503.426      0.23500      0.09720      213.864     0.77351     0.26849        5.89479       0.28681        6.29697       280.80      0.78245     "Methylcyclohexane"      
  MC-HEXANE      98.188     1029.9420      503.426      0.23500      0.09720      213.864     0.77351     0.26849        5.89479       0.28681        6.29697       280.80      0.78245     "Methylcyclohexane"      
  EC-C5          98.188     1025.1000      492.693      0.27000      0.10757      218.492     0.77065     0.26903        6.00692       0.27276        6.09014       283.00      0.53617     "Ethylcyclopentane"      
  EC-PENTAN      98.188     1025.1000      492.693      0.27000      0.10757      218.492     0.77065     0.26903        6.00692       0.27276        6.09014       283.00      0.53617     "Ethylcyclopentane"      
  TOLUENE        92.141     1065.1500      595.815      0.26400      0.13279      231.669     0.87124     0.26384        5.06183       0.26625        5.10809       245.10      0.64614     "Toluene"                
  C-C7           98.188     1087.7400      556.945      0.24200      0.08563      246.350     0.81449     0.27437        5.75063       0.27859        5.83900       280.00      0.65281     "Cycloheptane"           
  CYCLO-C7       98.188     1087.7400      556.945      0.24200      0.08563      246.350     0.81449     0.27437        5.75063       0.27859        5.83900       280.00      0.65281     "Cycloheptane"           
  C-HEPTANE      98.188     1087.7400      556.945      0.24200      0.08563      246.350     0.81449     0.27437        5.75063       0.27859        5.83900       280.00      0.65281     "Cycloheptane"           
  CYCLOHEPT      98.188     1087.7400      556.945      0.24200      0.08563      246.350     0.81449     0.27437        5.75063       0.27859        5.83900       280.00      0.65281     "Cycloheptane"           
  N-C8          114.231     1023.6600      361.144      0.39900      0.16355      258.194     0.70633     0.25909        7.88108       0.25978        7.90224       351.00      0.58099     "Octane"                 
  N-OCTANE      114.231     1023.6600      361.144      0.39900      0.16355      258.194     0.70633     0.25909        7.88108       0.25978        7.90224       351.00      0.58099     "Octane"                 
  OCTANE        114.231     1023.6600      361.144      0.39900      0.16355      258.194     0.70633     0.25909        7.88108       0.25978        7.90224       351.00      0.58099     "Octane"                 
  E-BENZENE     106.167     1110.8700      523.441      0.30400      0.14599      277.657     0.87086     0.26305        5.99091       0.26216        5.97067       285.10      0.72363     "Ethylbenzene"           
  P-XYLENE      106.167     1109.1600      509.227      0.32200      0.16309      281.681     0.86497     0.25904        6.05498       0.25488        5.95777       285.10      0.65065     "p-Xylene"               
  M-XYLENE      106.167     1110.6000      513.579      0.32700      0.15871      282.992     0.86812     0.25884        6.00692       0.25584        5.93723       285.10      0.65532     "m-Xylene"               
  O-XYLENE      106.167     1134.5400      541.281      0.31200      0.14199      292.632     0.88359     0.26349        5.92683       0.26587        5.98034       285.10      0.86923     "o-Xylene"               
  N-C9          128.258     1070.2800      332.136      0.44500      0.17833      303.318     0.72092     0.25708        8.89025       0.25799        8.92158       391.00      0.75412     "Nonane"                 
  N-NONANE      128.258     1070.2800      332.136      0.44500      0.17833      303.318     0.72092     0.25708        8.89025       0.25799        8.92158       391.00      0.75412     "Nonane"                 
  NONANE        128.258     1070.2800      332.136      0.44500      0.17833      303.318     0.72092     0.25708        8.89025       0.25799        8.92158       391.00      0.75412     "Nonane"                 
  C-C8          112.215     1164.9600      517.785      0.25400      0.10633      304.169     0.83922     0.27201        6.56757       0.27740        6.69781       320.00      0.92352     "Cyclooctane"            
  CYCLO-C8      112.215     1164.9600      517.785      0.25400      0.10633      304.169     0.83922     0.27201        6.56757       0.27740        6.69781       320.00      0.92352     "Cyclooctane"            
  C-OCTANE      112.215     1164.9600      517.785      0.25400      0.10633      304.169     0.83922     0.27201        6.56757       0.27740        6.69781       320.00      0.92352     "Cyclooctane"            
  CYCLOOCTA     112.215     1164.9600      517.785      0.25400      0.10633      304.169     0.83922     0.27201        6.56757       0.27740        6.69781       320.00      0.92352     "Cyclooctane"            
  CUMENE        120.194     1135.8000      465.426      0.32600      0.14709      306.396     0.86529     0.26589        6.96323       0.26399        6.91347       322.90      0.83587     "Cumene"                 
  I-C3-BENZ     120.194     1135.8000      465.426      0.32600      0.14709      306.396     0.86529     0.26589        6.96323       0.26399        6.91347       322.90      0.83587     "Cumene"                 
  1ME-BENZE     120.194     1135.8000      465.426      0.32600      0.14709      306.396     0.86529     0.26589        6.96323       0.26399        6.91347       322.90      0.83587     "Cumene"                 
  P-BENZENE     120.194     1149.0300      464.121      0.34500      0.15597      319.013     0.86492     0.26528        7.04812       0.26551        7.05426       325.10      1.02813     "Propylbenzene"          
  1E4M-BENZ     120.194     1152.3600      468.472      0.36400      0.14713      324.050     0.86496     0.26700        7.04812       0.26775        7.06815       325.10      1.05719     "1-Ethyl-4-methylbenzene"
  135TM-BEN     120.194     1147.1400      453.533      0.39900      0.15225      328.802     0.84785     0.25376        6.88794       0.26643        7.23181       325.10      1.06922     "1,3,5-Trimethylbenzene" 
  124TM-BEN     120.194     1168.3800      468.762      0.37700      0.16992      337.236     0.87804     0.26050        6.96803       0.26236        7.01778       325.10      1.15142     "1,2,4-Trimethylbenzene" 
  N-C10         142.285     1111.8600      306.030      0.49000      0.19556      345.150     0.73286     0.25636        9.99552       0.25548        9.96117       431.00      0.95919     "Decane"                 
  N-DECANE      142.285     1111.8600      306.030      0.49000      0.19556      345.150     0.73286     0.25636        9.99552       0.25548        9.96117       431.00      0.95919     "Decane"                 
  DECANE        142.285     1111.8600      306.030      0.49000      0.19556      345.150     0.73286     0.25636        9.99552       0.25548        9.96117       431.00      0.95919     "Decane"                 
  123TM-BEN     120.194     1196.1000      500.960      0.36700      0.14517      349.576     0.89681     0.27195        6.96803       0.26918        6.89707       325.10      1.25122     "1,2,3-Trimethylbenzene" 
  N-C11         156.312     1150.2000      287.175      0.53700      0.19988      384.043     0.74275     0.25677       11.03672       0.25617       11.01067       471.00      1.19966     "Undecane"               
  N-UNDECAN     156.312     1150.2000      287.175      0.53700      0.19988      384.043     0.74275     0.25677       11.03672       0.25617       11.01067       471.00      1.19966     "Undecane"               
  UNDECANE      156.312     1150.2000      287.175      0.53700      0.19988      384.043     0.74275     0.25677       11.03672       0.25617       11.01067       471.00      1.19966     "Undecane"               
  N-C12         170.338     1184.4000      263.969      0.57600      0.22596      420.658     0.75120     0.25083       12.07792       0.25110       12.09083       511.00      1.47934     "Dodecane"               
  N-DODECAN     170.338     1184.4000      263.969      0.57600      0.22596      420.658     0.75120     0.25083       12.07792       0.25110       12.09083       511.00      1.47934     "Dodecane"               
  DODECANE      170.338     1184.4000      263.969      0.57600      0.22596      420.658     0.75120     0.25083       12.07792       0.25110       12.09083       511.00      1.47934     "Dodecane"               
  NAPHTHALE     128.174     1347.1200      587.403      0.30400      0.15495      425.280     1.02232     0.26490        6.51951       0.27617        6.79693       311.10      2.63165     "Naphthalene"            
  N-C13         184.365     1215.0000      243.663      0.61800      0.24957      454.999     0.75853     0.24636       13.18320       0.24640       13.18545       551.00      1.80147     "Tridecane"              
  N-TRIDECA     184.365     1215.0000      243.663      0.61800      0.24957      454.999     0.75853     0.24636       13.18320       0.24640       13.18545       551.00      1.80147     "Tridecane"              
  TRIDECANE     184.365     1215.0000      243.663      0.61800      0.24957      454.999     0.75853     0.24636       13.18320       0.24640       13.18545       551.00      1.80147     "Tridecane"              
  2M-NAPHTH     142.200     1369.8000      513.434      0.37400      0.17281      466.600     1.00315     0.25848        7.40053       0.26953        7.71702       351.10      2.66503     "2-Methylnaphthalene"    
  1M-NAPHTH     142.200     1389.6000      522.136      0.34800      0.18922      472.925     1.02396     0.25912        7.40053       0.26555        7.58426       351.10      2.80041     "1-Methylnaphthalene"    
  N-C14         198.392     1247.4000      227.709      0.64400      0.26773      488.034     0.76483     0.24360       14.32051       0.24310       14.29108       591.00      2.17085     "Tetradecane"            
  N-TETRADE     198.392     1247.4000      227.709      0.64400      0.26773      488.034     0.76483     0.24360       14.32051       0.24310       14.29108       591.00      2.17085     "Tetradecane"            
  TETRADECA     198.392     1247.4000      227.709      0.64400      0.26773      488.034     0.76483     0.24360       14.32051       0.24310       14.29108       591.00      2.17085     "Tetradecane"            
  DPH-C1        168.238     1368.0000      393.052      0.48100      0.25578      507.975     1.00971     0.24145        9.01839       0.24991        9.33434       419.20      3.53557     "Diphenylmethane"        
  DPH-METHA     168.238     1368.0000      393.052      0.48100      0.25578      507.975     1.00971     0.24145        9.01839       0.24991        9.33434       419.20      3.53557     "Diphenylmethane"        
  N-C15         212.419     1274.4000      214.656      0.68500      0.27775      518.372     0.77032     0.24287       15.47384       0.24180       15.40562       631.00      2.58800     "Pentadecane"            
  N-PENTADE     212.419     1274.4000      214.656      0.68500      0.27775      518.372     0.77032     0.24287       15.47384       0.24180       15.40562       631.00      2.58800     "Pentadecane"            
  PENTADECA     212.419     1274.4000      214.656      0.68500      0.27775      518.372     0.77032     0.24287       15.47384       0.24180       15.40562       631.00      2.58800     "Pentadecane"            
  N-C16         226.446     1301.4000      203.053      0.71800      0.28806      547.620     0.77517     0.24081       16.56309       0.24036       16.53208       671.00      3.05726     "Hexadecane"             
  N-HEXADEC     226.446     1301.4000      203.053      0.71800      0.28806      547.620     0.77517     0.24081       16.56309       0.24036       16.53208       671.00      3.05726     "Hexadecane"             
  HEXADECAN     226.446     1301.4000      203.053      0.71800      0.28806      547.620     0.77517     0.24081       16.56309       0.24036       16.53208       671.00      3.05726     "Hexadecane"             
  N-C17         240.473     1324.8000      194.351      0.75300      0.28969      573.468     0.77963     0.24153       17.66837       0.24128       17.65041       711.00      3.55732     "Heptadecane"            
  N-HEPTADE     240.473     1324.8000      194.351      0.75300      0.28969      573.468     0.77963     0.24153       17.66837       0.24128       17.65041       711.00      3.55732     "Heptadecane"            
  HEPTADECA     240.473     1324.8000      194.351      0.75300      0.28969      573.468     0.77963     0.24153       17.66837       0.24128       17.65041       711.00      3.55732     "Heptadecane"            
  N-C18         254.500     1344.6000      187.099      0.80000      0.28700      597.383     0.78391     0.24695       19.04595       0.24335       18.76821       751.00      4.10945     "Octadecane"             
  N-OCTADEC     254.500     1344.6000      187.099      0.80000      0.28700      597.383     0.78391     0.24695       19.04595       0.24335       18.76821       751.00      4.10945     "Octadecane"             
  OCTADECAN     254.500     1344.6000      187.099      0.80000      0.28700      597.383     0.78391     0.24695       19.04595       0.24335       18.76821       751.00      4.10945     "Octadecane"             
  N-C19         268.527     1359.0000      168.244      0.84500      0.33466      622.571     0.78723     0.21390       18.54199       0.23053       19.98310       791.00      4.75103     "Nonadecane"             
  N-NONADEC     268.527     1359.0000      168.244      0.84500      0.33466      622.571     0.78723     0.21390       18.54199       0.23053       19.98310       791.00      4.75103     "Nonadecane"             
  NONADECAN     268.527     1359.0000      168.244      0.84500      0.33466      622.571     0.78723     0.21390       18.54199       0.23053       19.98310       791.00      4.75103     "Nonadecane"             
  12DPH-BEN     230.309     1542.6000      433.663      0.51621     -0.16199      629.600     0.91020     0.23288        8.89001       0.38311       14.62482       553.30      6.67159     "1,2-Diphenylbenzene"    
  PHENANTHR     178.233     1564.2000      416.258      0.47900      0.22743      641.000     0.97619     0.22006        8.87423       0.26623       10.73636       417.10      7.30344     "Phenanthrene"           
  ANTHRACEN     178.233     1564.7400      416.258      0.50100      0.43085      645.904     1.29129     0.21998        8.87423       0.19997        8.06685       417.10      6.68134     "Anthracene"             
  N-C20         282.554     1382.4000      155.190      0.86500      0.36534      650.345     0.78722     0.20933       20.01048       0.22250       21.27015       831.00      5.44791     "Eicosane"               
  N-EICOSAN     282.554     1382.4000      155.190      0.86500      0.36534      650.345     0.78722     0.20933       20.01048       0.22250       21.27015       831.00      5.44791     "Eicosane"               
  EICOSANE      282.554     1382.4000      155.190      0.86500      0.36534      650.345     0.78722     0.20933       20.01048       0.22250       21.27015       831.00      5.44791     "Eicosane"               
  N-C21         296.580     1400.4000      149.389      0.92147      0.36549      673.700     0.78927     0.20566       20.68891       0.22334       22.46799       871.00      6.19982     "Heneicosane"            
  N-HENEICO     296.580     1400.4000      149.389      0.92147      0.36549      673.700     0.78927     0.20566       20.68891       0.22334       22.46799       871.00      6.19982     "Heneicosane"            
  HENEICOSA     296.580     1400.4000      149.389      0.92147      0.36549      673.700     0.78927     0.20566       20.68891       0.22334       22.46799       871.00      6.19982     "Heneicosane"            
  13DPH-BEN     230.309     1589.4000      359.694      0.54274      0.15099      685.400     0.98848     0.24457       11.59737       0.29493       13.98551       553.30     10.18562     "1,3-Diphenylbenzene"    
  N-C22         310.607     1414.8000      142.137      0.98341      0.37333      695.480     0.79101     0.20207       21.58488       0.22176       23.68830       911.00      7.00179     "Docosane"               
  N-DOCOSAN     310.607     1414.8000      142.137      0.98341      0.37333      695.480     0.79101     0.20207       21.58488       0.22176       23.68830       911.00      7.00179     "Docosane"               
  DOCOSANE      310.607     1414.8000      142.137      0.98341      0.37333      695.480     0.79101     0.20207       21.58488       0.22176       23.68830       911.00      7.00179     "Docosane"               
  14DPH-BEN     230.309     1634.4000      433.663      0.58751      0.02517      708.800     1.02275     0.28872       11.67746       0.33530       13.56146       553.30     12.06661     "1,4-Diphenylbenzene"    
  N-C23         324.634     1422.0000      133.435      1.09624      0.38896      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  N-TRICOSA     324.634     1422.0000      133.435      1.09624      0.38896      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  TRICOSANE     324.634     1422.0000      133.435      1.09624      0.38896      716.360     0.79498     0.19917       22.77810       0.21752       24.87719       951.00      7.96064     "Tricosane"              
  N-C24         338.661     1440.0000      126.183      1.09757      0.40367      736.340     0.79350     0.19495       23.87566       0.21390       26.19650       991.00      8.77277     "Tetracosane"            
  N-TETRACO     338.661     1440.0000      126.183      1.09757      0.40367      736.340     0.79350     0.19495       23.87566       0.21390       26.19650       991.00      8.77277     "Tetracosane"            
  TETRACOSA     338.661     1440.0000      126.183      1.09757      0.40367      736.340     0.79350     0.19495       23.87566       0.21390       26.19650       991.00      8.77277     "Tetracosane"            
END
set xlabel "Molecular Weight"
set ylabel "Critical Temperature (R)"
set output "Figures/Table_003_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:3 with points notitle
set ylabel "Critical Pressure (psia)"
set output "Figures/Table_003_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:4 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_003_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:5 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_003_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:6 with points notitle
set ylabel "Boiling Temperature (F)"
set output "Figures/Table_003_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:7 with points notitle
set ylabel "Specific Gravity"
set output "Figures/Table_003_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:8 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_003_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:9 with points notitle
set ylabel "Critical Volume (ft3/lbmol)"
set output "Figures/Table_003_VC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:10 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_003_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:11 with points notitle
set ylabel "Viscosity Vc (ft3/lbmol)"
set output "Figures/Table_003_VISV_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:12 with points notitle
set ylabel "Parachor"
set output "Figures/Table_003_PCHOR_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:13 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_003_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:14 with points notitle

set title "EOS Fluid Characterization \"RK Library\""
show title

$Expt << END
#                               Tc           Pc                                      Tb                                     Vc                          VcVis                     Visc                   
# Component        MW          (R)         (psia)         AF          VTran         (F)           SG          Zc        (ft3/lbmol)      ZcVis       (ft3/lbmol)      Pchor       (cp)                 Full
#-----------   ---------   -----------   ----------   ----------   ----------   -----------   ---------   ---------   --------------   ---------   --------------   --------   ---------   ---------------------------
  HE              4.003        9.3420       32.924     -0.39000     -0.31494     -451.5069     0.05845     0.30142        0.91786       0.30142        0.91786        19.20         NaN     "Helium"                 
  HELIUM          4.003        9.3420       32.924     -0.39000     -0.31494     -451.5069     0.05845     0.30142        0.91786       0.30142        0.91786        19.20         NaN     "Helium"                 
  NE             20.180       79.9200      400.304     -0.01600     -0.16591     -408.8552     0.43433     0.31177        0.66797       0.31177        0.66797        41.30         NaN     "Neon"                   
  NEON           20.180       79.9200      400.304     -0.01600     -0.16591     -408.8552     0.43433     0.31177        0.66797       0.31177        0.66797        41.30         NaN     "Neon"                   
  AR             39.948      271.5480      710.395     -0.00200     -0.04299     -296.5826     0.46326     0.29119        1.19450       0.29119        1.19450        74.70         NaN     "Argon"                  
  ARGON          39.948      271.5480      710.395     -0.00200     -0.04299     -296.5826     0.46326     0.29119        1.19450       0.29119        1.19450        74.70         NaN     "Argon"                  
  KR             83.800      376.9200      797.708      0.00000     -0.01673     -235.7664     0.79151     0.28810        1.46088       0.28810        1.46088       148.80         NaN     "Krypton"                
  KRYPTON        83.800      376.9200      797.708      0.00000     -0.01673     -235.7664     0.79151     0.28810        1.46088       0.28810        1.46088       148.80         NaN     "Krypton"                
  XE            131.290      521.5320      847.020      0.00000      0.04199     -151.5933     1.13313     0.28606        1.89018       0.28606        1.89018       229.00         NaN     "Xenon"                  
  XENON         131.290      521.5320      847.020      0.00000      0.04199     -151.5933     1.13313     0.28606        1.89018       0.28606        1.89018       229.00         NaN     "Xenon"                  
  RN            222.018      678.6000      913.738      0.00000      0.06361      -61.6141     3.56702     0.28138        2.24258       0.28138        2.24258       382.30         NaN     "Radon"                  
  RADON         222.018      678.6000      913.738      0.00000      0.06361      -61.6141     3.56702     0.28138        2.24258       0.28138        2.24258       382.30         NaN     "Radon"                  
  H2              2.016       59.3640      187.534     -0.21700     -0.26651     -418.6468     0.02670     0.30273        1.02839       0.30273        1.02839        35.00         NaN     "Hydrogen"               
  HYDROGEN        2.016       59.3640      187.534     -0.21700     -0.26651     -418.6468     0.02670     0.30273        1.02839       0.30273        1.02839        35.00         NaN     "Hydrogen"               
  N2             28.014      227.1600      492.838      0.03700     -0.01131     -318.2698     0.27163     0.29178        1.44326       0.29178        1.44326        59.10         NaN     "Nitrogen"               
  NITROGEN       28.014      227.1600      492.838      0.03700     -0.01131     -318.2698     0.27163     0.29178        1.44326       0.29178        1.44326        59.10         NaN     "Nitrogen"               
  CO             28.010      239.1300      506.762      0.04500      0.00857     -311.2341     0.26666     0.29449        1.49132       0.29449        1.49132        61.70         NaN     "Carbon Monoxide"        
  O2             31.999      278.2440      731.425      0.00000     -0.00674     -293.0244     0.37638     0.28789        1.17527       0.28789        1.17527        53.10         NaN     "Oxygen"                 
  OXYGEN         31.999      278.2440      731.425      0.00000     -0.00674     -293.0244     0.37638     0.28789        1.17527       0.28789        1.17527        53.10         NaN     "Oxygen"                 
  NO             30.006      324.0000      939.845      0.58200      0.18436     -270.1082     0.40978     0.25113        0.92907       0.25113        0.92907        56.60         NaN     "Nitric Oxide"           
  N2O            44.013      557.2800     1052.249      0.00000      0.09848     -136.9589     0.70268     0.27338        1.55379       0.27338        1.55379        41.30         NaN     "Nitrous Oxide"          
  CO2            44.010      547.4160     1069.508      0.22500      0.30237     -143.1360     0.74887     0.27433        1.50686       0.27433        1.50686        80.00         NaN     "Carbon Dioxide"         
  H2S            34.082      672.1200     1299.973      0.09000      0.10237      -77.7157     0.79956     0.28292        1.56981       0.28292        1.56981        80.10         NaN     "Hydrogen Sulfide"       
  NH3            17.031      729.7200     1646.613      0.25700      0.29163      -53.3701     0.59081     0.24409        1.16086       0.24409        1.16086        58.00         NaN     "Ammonia"                
  AMMONIA        17.031      729.7200     1646.613      0.25700      0.29163      -53.3701     0.59081     0.24409        1.16086       0.24409        1.16086        58.00         NaN     "Ammonia"                
  SO2            64.065      775.4400     1143.478      0.00000      0.16464      -13.9670     1.37087     0.26853        1.95425       0.26853        1.95425       127.30         NaN     "Sulfur Dioxide"         
  NO2            46.006      775.8000     1464.881      0.83400      0.33428      -23.3588     1.47106     0.47294        2.68790       0.47294        2.68790        72.80         NaN     "Nitrogen Dioxide"       
  N2O4           92.011      775.8180     1464.881      1.00700     -0.70211      -23.3487     1.45811     0.47067        2.67508       0.47067        2.67508       145.60         NaN     "Nitrogen Tetroxide"     
  H2O            18.015     1164.8520     3200.113      0.34400      0.30324      154.6618     1.00897     0.22943        0.89623       0.22676        0.88578        52.80     1.12658     "Water"                  
  WATER          18.015     1164.8520     3200.113      0.34400      0.30324      154.6618     1.00897     0.22943        0.89623       0.22676        0.88578        52.80     1.12658     "Water"                  
  C1             16.043      343.0080      667.029      0.01100     -0.02208     -252.4182     0.13904     0.28620        1.57942       0.28620        1.57942        71.00         NaN     "Methane"                
  CH4            16.043      343.0080      667.029      0.01100     -0.02208     -252.4182     0.13904     0.28620        1.57942       0.28620        1.57942        71.00         NaN     "Methane"                
  METHANE        16.043      343.0080      667.029      0.01100     -0.02208     -252.4182     0.13904     0.28620        1.57942       0.28620        1.57942        71.00         NaN     "Methane"                
  C2             30.070      549.5760      706.624      0.09900      0.05026     -129.4358     0.30352     0.27924        2.33069       0.27924        2.33069       111.00         NaN     "Ethane"                 
  C2H6           30.070      549.5760      706.624      0.09900      0.05026     -129.4358     0.30352     0.27924        2.33069       0.27924        2.33069       111.00         NaN     "Ethane"                 
  ETHANE         30.070      549.5760      706.624      0.09900      0.05026     -129.4358     0.30352     0.27924        2.33069       0.27924        2.33069       111.00         NaN     "Ethane"                 
  C3             44.097      665.6940      616.120      0.15200      0.11077      -54.3437     0.49240     0.27630        3.20369       0.27630        3.20369       151.00         NaN     "Propane"                
  C3H8           44.097      665.6940      616.120      0.15200      0.11077      -54.3437     0.49240     0.27630        3.20369       0.27630        3.20369       151.00         NaN     "Propane"                
  PROPANE        44.097      665.6940      616.120      0.15200      0.11077      -54.3437     0.49240     0.27630        3.20369       0.27630        3.20369       151.00         NaN     "Propane"                
  C-C3           42.081      716.8500      808.585      0.13000     -0.13689      -34.3764     0.52108     0.27410        2.60781       0.27410        2.60781       132.00         NaN     "Cyclopropane"           
  CYCLO-C3       42.081      716.8500      808.585      0.13000     -0.13689      -34.3764     0.52108     0.27410        2.60781       0.27410        2.60781       132.00         NaN     "Cyclopropane"           
  C-PROPANE      42.081      716.8500      808.585      0.13000     -0.13689      -34.3764     0.52108     0.27410        2.60781       0.27410        2.60781       132.00         NaN     "Cyclopropane"           
  CYCLOPROP      42.081      716.8500      808.585      0.13000     -0.13689      -34.3764     0.52108     0.27410        2.60781       0.27410        2.60781       132.00         NaN     "Cyclopropane"           
  I-C4           58.123      734.1300      527.937      0.18600      0.15131       -5.8291     0.57417     0.28199        4.20805       0.28199        4.20805       188.80         NaN     "Isobutane"              
  ISO-C4         58.123      734.1300      527.937      0.18600      0.15131       -5.8291     0.57417     0.28199        4.20805       0.28199        4.20805       188.80         NaN     "Isobutane"              
  I-BUTANE       58.123      734.1300      527.937      0.18600      0.15131       -5.8291     0.57417     0.28199        4.20805       0.28199        4.20805       188.80         NaN     "Isobutane"              
  ISOBUTANE      58.123      734.1300      527.937      0.18600      0.15131       -5.8291     0.57417     0.28199        4.20805       0.28199        4.20805       188.80         NaN     "Isobutane"              
  N-C4           58.123      765.2160      550.563      0.20000      0.15129       11.4233     0.59416     0.27385        4.08471       0.27385        4.08471       191.00         NaN     "Butane"                 
  N-BUTANE       58.123      765.2160      550.563      0.20000      0.15129       11.4233     0.59416     0.27385        4.08471       0.27385        4.08471       191.00         NaN     "Butane"                 
  BUTANE         58.123      765.2160      550.563      0.20000      0.15129       11.4233     0.59416     0.27385        4.08471       0.27385        4.08471       191.00         NaN     "Butane"                 
  NEO-C5         72.150      780.7500      463.976      0.19700      0.12581       29.2928     0.60543     0.26895        4.85680       0.26895        4.85680       225.90         NaN     "Neopentane"             
  NEOPENTAN      72.150      780.7500      463.976      0.19700      0.12581       29.2928     0.60543     0.26895        4.85680       0.26895        4.85680       225.90         NaN     "Neopentane"             
  C-C4           56.108      828.0000      723.738      0.18500      0.09906       36.7331     0.70340     0.28442        3.49203       0.28442        3.49203       166.00         NaN     "Cyclobutane"            
  CYCLO-C4       56.108      828.0000      723.738      0.18500      0.09906       36.7331     0.70340     0.28442        3.49203       0.28442        3.49203       166.00         NaN     "Cyclobutane"            
  C-BUTANE       56.108      828.0000      723.738      0.18500      0.09906       36.7331     0.70340     0.28442        3.49203       0.28442        3.49203       166.00         NaN     "Cyclobutane"            
  CYCLOBUTA      56.108      828.0000      723.738      0.18500      0.09906       36.7331     0.70340     0.28442        3.49203       0.28442        3.49203       166.00         NaN     "Cyclobutane"            
  I-C5           72.150      828.7020      490.373      0.22900      0.13738       56.4321     0.63282     0.27231        4.93849       0.27231        4.93849       227.40         NaN     "Isopentane"             
  ISO-C5         72.150      828.7020      490.373      0.22900      0.13738       56.4321     0.63282     0.27231        4.93849       0.27231        4.93849       227.40         NaN     "Isopentane"             
  I-PENTANE      72.150      828.7020      490.373      0.22900      0.13738       56.4321     0.63282     0.27231        4.93849       0.27231        4.93849       227.40         NaN     "Isopentane"             
  ISOPENTAN      72.150      828.7020      490.373      0.22900      0.13738       56.4321     0.63282     0.27231        4.93849       0.27231        4.93849       227.40         NaN     "Isopentane"             
  N-C5           72.150      845.4600      488.777      0.25200      0.16195       67.0413     0.63925     0.26837        4.98174       0.26691        4.95462       231.00     0.23558     "Pentane"                
  N-PENTANE      72.150      845.4600      488.777      0.25200      0.16195       67.0413     0.63925     0.26837        4.98174       0.26691        4.95462       231.00     0.23558     "Pentane"                
  PENTANE        72.150      845.4600      488.777      0.25200      0.16195       67.0413     0.63925     0.26837        4.98174       0.26691        4.95462       231.00     0.23558     "Pentane"                
  C-C5           70.134      920.8800      653.830      0.00000      0.09631       97.8151     0.75229     0.27554        4.16480       0.28422        4.29585       203.00     0.40356     "Cyclopentane"           
  CYCLO-C5       70.134      920.8800      653.830      0.00000      0.09631       97.8151     0.75229     0.27554        4.16480       0.28422        4.29585       203.00     0.40356     "Cyclopentane"           
  C-PENTANE      70.134      920.8800      653.830      0.00000      0.09631       97.8151     0.75229     0.27554        4.16480       0.28422        4.29585       203.00     0.40356     "Cyclopentane"           
  CYCLOPENT      70.134      920.8800      653.830      0.00000      0.09631       97.8151     0.75229     0.27554        4.16480       0.28422        4.29585       203.00     0.40356     "Cyclopentane"           
  22DM-C4        86.177      879.6600      446.716      0.23300      0.11243       93.3648     0.65618     0.27220        5.75223       0.27658        5.84481       263.00     0.26594     "2,2-Dimethylbutane"     
  22DM-BUTA      86.177      879.6600      446.716      0.23300      0.11243       93.3648     0.65618     0.27220        5.75223       0.27658        5.84481       263.00     0.26594     "2,2-Dimethylbutane"     
  23DM-C4        86.177      899.8200      453.968      0.24800      0.12830      105.1123     0.66852     0.26929        5.72820       0.27319        5.81105       263.40     0.29518     "2,3-Dimethylbutane"     
  23DM-BUTA      86.177      899.8200      453.968      0.24800      0.12830      105.1123     0.66852     0.26929        5.72820       0.27319        5.81105       263.40     0.29518     "2,3-Dimethylbutane"     
  2M-C5          86.177      895.5000      436.564      0.27800      0.15517      104.6467     0.66027     0.26684        5.87397       0.26812        5.90208       268.80     0.29498     "2-Methylpentane"        
  2M-PENTAN      86.177      895.5000      436.564      0.27800      0.15517      104.6467     0.66027     0.26684        5.87397       0.26812        5.90208       268.80     0.29498     "2-Methylpentane"        
  3M-C5          86.177      907.9200      452.518      0.27300      0.14153      110.3819     0.67123     0.27281        5.87397       0.27081        5.83095       267.40     0.31187     "3-Methylpentane"        
  3M-PENTAN      86.177      907.9200      452.518      0.27300      0.14153      110.3819     0.67123     0.27281        5.87397       0.27081        5.83095       267.40     0.31187     "3-Methylpentane"        
  N-C6           86.177      913.6800      438.739      0.30000      0.17087      115.8105     0.66642     0.26377        5.89479       0.26460        5.91337       271.00     0.32245     "Hexane"                 
  N-HEXANE       86.177      913.6800      438.739      0.30000      0.17087      115.8105     0.66642     0.26377        5.89479       0.26460        5.91337       271.00     0.32245     "Hexane"                 
  HEXANE         86.177      913.6800      438.739      0.30000      0.17087      115.8105     0.66642     0.26377        5.89479       0.26460        5.91337       271.00     0.32245     "Hexane"                 
  MC-C5          84.161      959.0220      548.823      0.22700      0.11837      130.9218     0.75513     0.27249        5.10989       0.28361        5.31843       243.00     0.53135     "Methylcyclopentane"     
  MC-PENTAN      84.161      959.0220      548.823      0.22700      0.11837      130.9218     0.75513     0.27249        5.10989       0.28361        5.31843       243.00     0.53135     "Methylcyclopentane"     
  22DM-C5       100.204      936.7200      401.755      0.28700      0.13987      135.6926     0.68037     0.26619        6.66048       0.27202        6.80633       305.90     0.35620     "2,2-Dimethylpentane"    
  22DM-PENT     100.204      936.7200      401.755      0.28700      0.13987      135.6926     0.68037     0.26619        6.66048       0.27202        6.80633       305.90     0.35620     "2,2-Dimethylpentane"    
  BENZENE        78.114     1011.6900      709.960      0.21000      0.12817      147.9704     0.88545     0.26815        4.10073       0.27937        4.27226       205.10     0.69219     "Benzene"                
  24DM-C5       100.204      935.4600      397.403      0.30400      0.14904      135.5633     0.67923     0.26474        6.68771       0.27039        6.83051       306.60     0.35931     "2,4-Dimethylpentane"    
  24DM-PENT     100.204      935.4600      397.403      0.30400      0.14904      135.5633     0.67923     0.26474        6.68771       0.27039        6.83051       306.60     0.35931     "2,4-Dimethylpentane"    
  C-C6           84.161      996.3000      590.739      0.21100      0.10493      149.4507     0.78449     0.27259        4.93369       0.30137        5.45461       240.80     1.05399     "Cyclohexane"            
  CYCLO-C6       84.161      996.3000      590.739      0.21100      0.10493      149.4507     0.78449     0.27259        4.93369       0.30137        5.45461       240.80     1.05399     "Cyclohexane"            
  C-HEXANE       84.161      996.3000      590.739      0.21100      0.10493      149.4507     0.78449     0.27259        4.93369       0.30137        5.45461       240.80     1.05399     "Cyclohexane"            
  CYCLOHEXA      84.161      996.3000      590.739      0.21100      0.10493      149.4507     0.78449     0.27259        4.93369       0.30137        5.45461       240.80     1.05399     "Cyclohexane"            
  223TM-C4      100.204      955.9800      427.861      0.25000      0.10841      144.0033     0.69598     0.26562        6.36894       0.27817        6.66993       299.00     0.37777     "2,2,3-Trimethylbutane"  
  223TM-BUT     100.204      955.9800      427.861      0.25000      0.10841      144.0033     0.69598     0.26562        6.36894       0.27817        6.66993       299.00     0.37777     "2,2,3-Trimethylbutane"  
  33DM-C5       100.204      965.3400      427.861      0.26900      0.12026      149.9139     0.69945     0.27396        6.63325       0.27604        6.68355       303.00     0.40052     "3,3-Dimethylpentane"    
  33DM-PENT     100.204      965.3400      427.861      0.26900      0.12026      149.9139     0.69945     0.27396        6.63325       0.27604        6.68355       303.00     0.40052     "3,3-Dimethylpentane"    
  23DM-C5       100.204      967.1400      422.060      0.29700      0.13908      151.9075     0.70127     0.25600        6.29526       0.27263        6.70430       303.40     0.41702     "2,3-Dimethylpentane"    
  23DM-PENT     100.204      967.1400      422.060      0.29700      0.13908      151.9075     0.70127     0.25600        6.29526       0.27263        6.70430       303.40     0.41702     "2,3-Dimethylpentane"    
  2M-C6         100.204      954.1800      395.953      0.33100      0.17391      147.7052     0.68516     0.26077        6.74377       0.26531        6.86117       308.80     0.40024     "2-Methylhexane"         
  2M-HEXANE     100.204      954.1800      395.953      0.33100      0.17391      147.7052     0.68516     0.26077        6.74377       0.26531        6.86117       308.80     0.40024     "2-Methylhexane"         
  3M-C6         100.204      963.3600      407.556      0.32300      0.16201      151.7170     0.69350     0.25512        6.47146       0.26794        6.79688       307.40     0.41711     "3-Methylhexane"         
  3M-HEXANE     100.204      963.3600      407.556      0.32300      0.16201      151.7170     0.69350     0.25512        6.47146       0.26794        6.79688       307.40     0.41711     "3-Methylhexane"         
  3E-C5         100.204      972.9000      419.159      0.31100      0.15496      155.9865     0.70444     0.26739        6.66048       0.26943        6.71121       305.00     0.43562     "3-Ethylpentane"         
  3E-PENTAN     100.204      972.9000      419.159      0.31100      0.15496      155.9865     0.70444     0.26739        6.66048       0.26943        6.71121       305.00     0.43562     "3-Ethylpentane"         
  N-C7          100.204      972.3600      397.403      0.35000      0.18867      159.0427     0.69012     0.26110        6.85590       0.26220        6.88483       311.00     0.43989     "Heptane"                
  N-HEPTANE     100.204      972.3600      397.403      0.35000      0.18867      159.0427     0.69012     0.26110        6.85590       0.26220        6.88483       311.00     0.43989     "Heptane"                
  HEPTANE       100.204      972.3600      397.403      0.35000      0.18867      159.0427     0.69012     0.26110        6.85590       0.26220        6.88483       311.00     0.43989     "Heptane"                
  MC-C6          98.188     1029.9420      503.426      0.23500      0.12083      180.0718     0.77494     0.26849        5.89479       0.28628        6.28537       280.80     0.78245     "Methylcyclohexane"      
  MC-HEXANE      98.188     1029.9420      503.426      0.23500      0.12083      180.0718     0.77494     0.26849        5.89479       0.28628        6.28537       280.80     0.78245     "Methylcyclohexane"      
  EC-C5          98.188     1025.1000      492.693      0.27000      0.13684      178.4426     0.77229     0.26903        6.00692       0.27223        6.07843       283.00     0.53716     "Ethylcyclopentane"      
  EC-PENTAN      98.188     1025.1000      492.693      0.27000      0.13684      178.4426     0.77229     0.26903        6.00692       0.27223        6.07843       283.00     0.53716     "Ethylcyclopentane"      
  TOLUENE        92.141     1065.1500      595.815      0.26400      0.15863      190.9995     0.87297     0.26384        5.06183       0.26573        5.09799       245.10     0.64614     "Toluene"                
  C-C7           98.188     1087.7400      556.945      0.24200      0.10708      209.2180     0.81587     0.27437        5.75063       0.27815        5.82987       280.00     0.65358     "Cycloheptane"           
  CYCLO-C7       98.188     1087.7400      556.945      0.24200      0.10708      209.2180     0.81587     0.27437        5.75063       0.27815        5.82987       280.00     0.65358     "Cycloheptane"           
  C-HEPTANE      98.188     1087.7400      556.945      0.24200      0.10708      209.2180     0.81587     0.27437        5.75063       0.27815        5.82987       280.00     0.65358     "Cycloheptane"           
  CYCLOHEPT      98.188     1087.7400      556.945      0.24200      0.10708      209.2180     0.81587     0.27437        5.75063       0.27815        5.82987       280.00     0.65358     "Cycloheptane"           
  N-C8          114.231     1023.6600      361.144      0.39900      0.21024      198.2287     0.70856     0.25909        7.88108       0.25913        7.88247       351.00     0.58477     "Octane"                 
  N-OCTANE      114.231     1023.6600      361.144      0.39900      0.21024      198.2287     0.70856     0.25909        7.88108       0.25913        7.88247       351.00     0.58477     "Octane"                 
  OCTANE        114.231     1023.6600      361.144      0.39900      0.21024      198.2287     0.70856     0.25909        7.88108       0.25913        7.88247       351.00     0.58477     "Octane"                 
  E-BENZENE     106.167     1110.8700      523.441      0.30400      0.17445      227.6574     0.87270     0.26305        5.99091       0.26161        5.95809       285.10     0.72363     "Ethylbenzene"           
  P-XYLENE      106.167     1109.1600      509.227      0.32200      0.19388      228.4878     0.86693     0.25904        6.05498       0.25431        5.94431       285.10     0.65065     "p-Xylene"               
  M-XYLENE      106.167     1110.6000      513.579      0.32700      0.19002      228.7955     0.87009     0.25884        6.00692       0.25526        5.92373       285.10     0.65532     "m-Xylene"               
  O-XYLENE      106.167     1134.5400      541.281      0.31200      0.17007      239.9687     0.88542     0.26349        5.92683       0.26532        5.96801       285.10     0.86923     "o-Xylene"               
  N-C9          128.258     1070.2800      332.136      0.44500      0.22600      234.3173     0.72327     0.25708        8.89025       0.25731        8.89819       391.00     0.75913     "Nonane"                 
  N-NONANE      128.258     1070.2800      332.136      0.44500      0.22600      234.3173     0.72327     0.25708        8.89025       0.25731        8.89819       391.00     0.75913     "Nonane"                 
  NONANE        128.258     1070.2800      332.136      0.44500      0.22600      234.3173     0.72327     0.25708        8.89025       0.25731        8.89819       391.00     0.75913     "Nonane"                 
  C-C8          112.215     1164.9600      517.785      0.25400      0.12572      261.9057     0.84055     0.27201        6.56757       0.27699        6.68798       320.00     0.92467     "Cyclooctane"            
  CYCLO-C8      112.215     1164.9600      517.785      0.25400      0.12572      261.9057     0.84055     0.27201        6.56757       0.27699        6.68798       320.00     0.92467     "Cyclooctane"            
  C-OCTANE      112.215     1164.9600      517.785      0.25400      0.12572      261.9057     0.84055     0.27201        6.56757       0.27699        6.68798       320.00     0.92467     "Cyclooctane"            
  CYCLOOCTA     112.215     1164.9600      517.785      0.25400      0.12572      261.9057     0.84055     0.27201        6.56757       0.27699        6.68798       320.00     0.92467     "Cyclooctane"            
  CUMENE        120.194     1135.8000      465.426      0.32600      0.17676      251.4260     0.86716     0.26589        6.96323       0.26342        6.89855       322.90     0.83587     "Cumene"                 
  I-C3-BENZ     120.194     1135.8000      465.426      0.32600      0.17676      251.4260     0.86716     0.26589        6.96323       0.26342        6.89855       322.90     0.83587     "Cumene"                 
  1ME-BENZE     120.194     1135.8000      465.426      0.32600      0.17676      251.4260     0.86716     0.26589        6.96323       0.26342        6.89855       322.90     0.83587     "Cumene"                 
  P-BENZENE     120.194     1149.0300      464.121      0.34500      0.18704      259.9138     0.86686     0.26528        7.04812       0.26496        7.03962       325.10     1.02996     "Propylbenzene"          
  1E4M-BENZ     120.194     1152.3600      468.472      0.36400      0.17893      261.3173     0.86593     0.26700        7.04812       0.26748        7.06085       325.10     1.05813     "1-Ethyl-4-methylbenzene"
  135TM-BEN     120.194     1147.1400      453.533      0.39900      0.18923      260.4158     0.85000     0.25376        6.88794       0.26580        7.21493       325.10     1.07150     "1,3,5-Trimethylbenzene" 
  124TM-BEN     120.194     1168.3800      468.762      0.37700      0.19887      271.2946     0.87603     0.26050        6.96803       0.26293        7.03279       325.10     1.14941     "1,2,4-Trimethylbenzene" 
  N-C10         142.285     1111.8600      306.030      0.49000      0.24413      267.6352     0.73532     0.25636        9.99552       0.25479        9.93400       431.00     0.96587     "Decane"                 
  N-DECANE      142.285     1111.8600      306.030      0.49000      0.24413      267.6352     0.73532     0.25636        9.99552       0.25479        9.93400       431.00     0.96587     "Decane"                 
  DECANE        142.285     1111.8600      306.030      0.49000      0.24413      267.6352     0.73532     0.25636        9.99552       0.25479        9.93400       431.00     0.96587     "Decane"                 
  123TM-BEN     120.194     1196.1000      500.960      0.36700      0.17179      283.6454     0.89493     0.27195        6.96803       0.26971        6.91067       325.10     1.24933     "1,2,3-Trimethylbenzene" 
  N-C11         156.312     1150.2000      287.175      0.53700      0.24942      297.9203     0.74529     0.25677       11.03672       0.25545       10.98003       471.00     1.20847     "Undecane"               
  N-UNDECAN     156.312     1150.2000      287.175      0.53700      0.24942      297.9203     0.74529     0.25677       11.03672       0.25545       10.98003       471.00     1.20847     "Undecane"               
  UNDECANE      156.312     1150.2000      287.175      0.53700      0.24942      297.9203     0.74529     0.25677       11.03672       0.25545       10.98003       471.00     1.20847     "Undecane"               
  N-C12         170.338     1184.4000      263.969      0.57600      0.27587      327.6884     0.75385     0.25083       12.07792       0.25038       12.05604       511.00     1.49108     "Dodecane"               
  N-DODECAN     170.338     1184.4000      263.969      0.57600      0.27587      327.6884     0.75385     0.25083       12.07792       0.25038       12.05604       511.00     1.49108     "Dodecane"               
  DODECANE      170.338     1184.4000      263.969      0.57600      0.27587      327.6884     0.75385     0.25083       12.07792       0.25038       12.05604       511.00     1.49108     "Dodecane"               
  NAPHTHALE     128.174     1347.1200      587.403      0.30400      0.17849      364.3929     1.02988     0.26490        6.51951       0.27415        6.74707       311.10     2.63165     "Naphthalene"            
  N-C13         184.365     1215.0000      243.663      0.61800      0.30013      355.2427     0.76131     0.24636       13.18320       0.24567       13.14615       551.00     1.81708     "Tridecane"              
  N-TRIDECA     184.365     1215.0000      243.663      0.61800      0.30013      355.2427     0.76131     0.24636       13.18320       0.24567       13.14615       551.00     1.81708     "Tridecane"              
  TRIDECANE     184.365     1215.0000      243.663      0.61800      0.30013      355.2427     0.76131     0.24636       13.18320       0.24567       13.14615       551.00     1.81708     "Tridecane"              
  2M-NAPHTH     142.200     1369.8000      513.434      0.37400      0.20268      389.4986     1.01193     0.25848        7.40053       0.26731        7.65342       351.10     2.68017     "2-Methylnaphthalene"    
  1M-NAPHTH     142.200     1389.6000      522.136      0.34800      0.20908      400.3297     1.02477     0.25912        7.40053       0.26535        7.57854       351.10     2.80178     "1-Methylnaphthalene"    
  N-C14         198.392     1247.4000      227.709      0.64400      0.31759      383.3630     0.76767     0.24360       14.32051       0.24237       14.24831       591.00     2.19085     "Tetradecane"            
  N-TETRADE     198.392     1247.4000      227.709      0.64400      0.31759      383.3630     0.76767     0.24360       14.32051       0.24237       14.24831       591.00     2.19085     "Tetradecane"            
  TETRADECA     198.392     1247.4000      227.709      0.64400      0.31759      383.3630     0.76767     0.24360       14.32051       0.24237       14.24831       591.00     2.19085     "Tetradecane"            
  DPH-C1        168.238     1368.0000      393.052      0.48100      0.28663      411.7840     1.01090     0.24145        9.01839       0.24963        9.32401       419.20     3.53892     "Diphenylmethane"        
  DPH-METHA     168.238     1368.0000      393.052      0.48100      0.28663      411.7840     1.01090     0.24145        9.01839       0.24963        9.32401       419.20     3.53892     "Diphenylmethane"        
  N-C15         212.419     1274.4000      214.656      0.68500      0.32817      407.3988     0.77323     0.24287       15.47384       0.24106       15.35880       631.00     2.61367     "Pentadecane"            
  N-PENTADE     212.419     1274.4000      214.656      0.68500      0.32817      407.3988     0.77323     0.24287       15.47384       0.24106       15.35880       631.00     2.61367     "Pentadecane"            
  PENTADECA     212.419     1274.4000      214.656      0.68500      0.32817      407.3988     0.77323     0.24287       15.47384       0.24106       15.35880       631.00     2.61367     "Pentadecane"            
  N-C16         226.446     1301.4000      203.053      0.71800      0.33843      431.4201     0.77814     0.24081       16.56309       0.23963       16.48157       671.00     3.08957     "Hexadecane"             
  N-HEXADEC     226.446     1301.4000      203.053      0.71800      0.33843      431.4201     0.77814     0.24081       16.56309       0.23963       16.48157       671.00     3.08957     "Hexadecane"             
  HEXADECAN     226.446     1301.4000      203.053      0.71800      0.33843      431.4201     0.77814     0.24081       16.56309       0.23963       16.48157       671.00     3.08957     "Hexadecane"             
  N-C17         240.473     1324.8000      194.351      0.75300      0.34028      452.0389     0.78263     0.24153       17.66837       0.24055       17.59660       711.00     3.59702     "Heptadecane"            
  N-HEPTADE     240.473     1324.8000      194.351      0.75300      0.34028      452.0389     0.78263     0.24153       17.66837       0.24055       17.59660       711.00     3.59702     "Heptadecane"            
  HEPTADECA     240.473     1324.8000      194.351      0.75300      0.34028      452.0389     0.78263     0.24153       17.66837       0.24055       17.59660       711.00     3.59702     "Heptadecane"            
  N-C18         254.500     1344.6000      187.099      0.80000      0.33853      469.7607     0.78697     0.24695       19.04595       0.24261       18.71068       751.00     4.15804     "Octadecane"             
  N-OCTADEC     254.500     1344.6000      187.099      0.80000      0.33853      469.7607     0.78697     0.24695       19.04595       0.24261       18.71068       751.00     4.15804     "Octadecane"             
  OCTADECAN     254.500     1344.6000      187.099      0.80000      0.33853      469.7607     0.78697     0.24695       19.04595       0.24261       18.71068       751.00     4.15804     "Octadecane"             
  N-C19         268.527     1359.0000      168.244      0.84500      0.38722      491.5103     0.79058     0.21464       18.60587       0.22976       19.91678       791.00     4.81522     "Nonadecane"             
  N-NONADEC     268.527     1359.0000      168.244      0.84500      0.38722      491.5103     0.79058     0.21464       18.60587       0.22976       19.91678       791.00     4.81522     "Nonadecane"             
  NONADECAN     268.527     1359.0000      168.244      0.84500      0.38722      491.5103     0.79058     0.21464       18.60587       0.22976       19.91678       791.00     4.81522     "Nonadecane"             
  12DPH-BEN     230.309     1542.6000      433.663      0.00000     -0.38838      513.0928     0.75512     0.22579        8.61924       0.42638       16.27671       553.30     2.31427     "1,2-Diphenylbenzene"    
  PHENANTHR     178.233     1564.2000      416.258      0.47900      0.24845      530.8724     0.97413     0.22006        8.87423       0.26676       10.75755       417.10     7.28877     "Phenanthrene"           
  ANTHRACEN     178.233     1564.7400      416.258      0.50100      0.45647      531.2144     1.29459     0.21998        8.87423       0.19946        8.04629       417.10     6.68134     "Anthracene"             
  N-C20         282.554     1382.4000      155.190      0.86500      0.41719      517.2513     0.79069     0.21014       20.08793       0.22175       21.19812       831.00     5.52923     "Eicosane"               
  N-EICOSAN     282.554     1382.4000      155.190      0.86500      0.41719      517.2513     0.79069     0.21014       20.08793       0.22175       21.19812       831.00     5.52923     "Eicosane"               
  EICOSANE      282.554     1382.4000      155.190      0.86500      0.41719      517.2513     0.79069     0.21014       20.08793       0.22175       21.19812       831.00     5.52923     "Eicosane"               
  N-C21         296.580     1400.4000      149.389      0.00000      0.42306      534.5215     0.79827     0.23015       23.15297       0.20984       21.10973       871.00     2.97532     "Heneicosane"            
  N-HENEICO     296.580     1400.4000      149.389      0.00000      0.42306      534.5215     0.79827     0.23015       23.15297       0.20984       21.10973       871.00     2.97532     "Heneicosane"            
  HENEICOSA     296.580     1400.4000      149.389      0.00000      0.42306      534.5215     0.79827     0.23015       23.15297       0.20984       21.10973       871.00     2.97532     "Heneicosane"            
  13DPH-BEN     230.309     1589.4000      359.694      0.00000     -0.04578      562.2583     0.79436     0.24457       11.59737       0.34053       16.14796       553.30     3.51569     "1,3-Diphenylbenzene"    
  N-C22         310.607     1414.8000      142.137      0.00000      0.43389      550.8229     0.80230     0.22848       24.40591       0.20763       22.17896       911.00     3.29769     "Docosane"               
  N-DOCOSAN     310.607     1414.8000      142.137      0.00000      0.43389      550.8229     0.80230     0.22848       24.40591       0.20763       22.17896       911.00     3.29769     "Docosane"               
  DOCOSANE      310.607     1414.8000      142.137      0.00000      0.43389      550.8229     0.80230     0.22848       24.40591       0.20763       22.17896       911.00     3.29769     "Docosane"               
  14DPH-BEN     230.309     1634.4000      433.663      0.00000     -0.20989      570.9818     0.81586     0.28872       11.67746       0.38849       15.71268       553.30     3.93164     "1,4-Diphenylbenzene"    
  N-C23         324.634     1422.0000      133.435      0.00000      0.41426      563.8474     0.76198     0.21880       25.02271       0.21142       24.17961       951.00     2.83514     "Tricosane"              
  N-TRICOSA     324.634     1422.0000      133.435      0.00000      0.41426      563.8474     0.76198     0.21880       25.02271       0.21142       24.17961       951.00     2.83514     "Tricosane"              
  TRICOSANE     324.634     1422.0000      133.435      0.00000      0.41426      563.8474     0.76198     0.21880       25.02271       0.21142       24.17961       951.00     2.83514     "Tricosane"              
  N-C24         338.661     1440.0000      126.183      0.00000      0.46840      583.9842     0.80845     0.22467       27.51463       0.19934       24.41285       991.00     4.04463     "Tetracosane"            
  N-TETRACO     338.661     1440.0000      126.183      0.00000      0.46840      583.9842     0.80845     0.22467       27.51463       0.19934       24.41285       991.00     4.04463     "Tetracosane"            
  TETRACOSA     338.661     1440.0000      126.183      0.00000      0.46840      583.9842     0.80845     0.22467       27.51463       0.19934       24.41285       991.00     4.04463     "Tetracosane"            
END
set xlabel "Molecular Weight"
set ylabel "Critical Temperature (R)"
set output "Figures/Table_004_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:3 with points notitle
set ylabel "Critical Pressure (psia)"
set output "Figures/Table_004_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:4 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_004_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:5 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_004_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:6 with points notitle
set ylabel "Boiling Temperature (F)"
set output "Figures/Table_004_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:7 with points notitle
set ylabel "Specific Gravity"
set output "Figures/Table_004_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:8 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_004_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:9 with points notitle
set ylabel "Critical Volume (ft3/lbmol)"
set output "Figures/Table_004_VC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:10 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_004_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:11 with points notitle
set ylabel "Viscosity Vc (ft3/lbmol)"
set output "Figures/Table_004_VISV_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:12 with points notitle
set ylabel "Parachor"
set output "Figures/Table_004_PCHOR_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:13 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_004_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:14 with points notitle

set output
